library("aroma.core")
verbose <- Arguments$getVerbose(-8, timestamp=TRUE)
ar <- AromaRepository(verbose=TRUE)

verbose && enter(verbose, "Downloading annotation data")

chipType <- "MoEx-1_0-st-v1"
verbose && cat(verbose, "Chip type: ", chipType)

pathname <- downloadCDF(ar, chipType)
verbose && cat(verbose, "CDF: ", pathname)

pathname <- downloadCDF(ar, chipType, tags="coreR1,A20080718,MR")
verbose && cat(verbose, "CDF: ", pathname)

pathname <- downloadACS(ar, chipType, tags=".*")
verbose && cat(verbose, "ACS: ", pathname)

verbose && exit(verbose)
