% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_confidence_set.R
\name{get.difference.matrix}
\alias{get.difference.matrix}
\title{Construct a difference matrix for argmin hypothesis testing}
\usage{
get.difference.matrix(data, r)
}
\arguments{
\item{data}{A \code{n} by \code{p} data matrix; each row is a \code{p}-dimensional sample.}

\item{r}{An integer between 1 and \code{p}, indicating the reference column (dimension).}
}
\value{
A \code{n} by \code{(p-1)} matrix where each row is the difference between the \code{r}-th column and the remaining columns.
}
\description{
Given a data matrix and a reference column index, construct the difference matrix
used in hypothesis testing procedures. Each column represents the difference
between the reference dimension and one of the remaining dimensions.
}
\examples{
set.seed(1)
data <- matrix(rnorm(50), nrow = 10)
diff.mat <- get.difference.matrix(data, r = 2)

}
\keyword{internal}
