% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arakno.R
\name{checknames}
\alias{checknames}
\title{Check taxa names in WSC.}
\usage{
checknames(tax, full = FALSE, order = FALSE)
}
\arguments{
\item{tax}{A taxon name or vector with taxa names.}

\item{full}{returns the full list of names.}

\item{order}{Order taxa alphabetically or keep as in tax.}
}
\value{
If any mismatches, a matrix with taxa not found in WSC or, if full = TRUE, the full list of names.
}
\description{
Check taxa names against the World Spider Catalogue.
}
\details{
This function will check if all species, genera and family names in tax are updated according to the World Spider Catalogue (2025). If not, it returns a matrix with nomenclature changes, valid synonyms or possible misspellings using fuzzy matching (Levenshtein edit distance).
}
\examples{
\dontrun{
tax = c("Nemesis", "Nemesia brauni", "Iberesia machadoi", "Nemesia bacelari")
checknames(tax)
checknames(tax, full = TRUE, order = TRUE)
}
}
\references{
World Spider Catalog (2025). World Spider Catalog. Version 26. Natural History Museum Bern, online at http://wsc.nmbe.ch. doi: 10.24436/2.
}
