% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aqp-label-placement-solvers.R
\name{findOverlap}
\alias{findOverlap}
\alias{overlapMetrics}
\title{Find Overlap within a Sequence}
\usage{
findOverlap(x, thresh)

overlapMetrics(x, thresh)
}
\arguments{
\item{x}{vector of relative horizontal positions, one for each profile}

\item{thresh}{threshold defining "overlap", typically < 1

@return a \code{list}:
\itemize{
\item \code{idx}: unique index to overlapping elements in \code{x}
\item \code{ov}: normalized overlap (see details)
}}
}
\value{
unique index to affected (overlapping) elements in \code{x}
}
\description{
Establish which elements within a vector of horizontal positions overlap beyond a given threshold

Desc.
}
\examples{

x <- c(1, 2, 3, 3.4, 3.5, 5, 6, 10)

findOverlap(x, thresh = 0.5)


x <- c(1, 2, 3, 3.4, 3.5, 5, 6, 10)

overlapMetrics(x, thresh = 0.5)


}
