% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilProfileCollection-methods.R
\docType{methods}
\name{isEmpty,SoilProfileCollection-method}
\alias{isEmpty,SoilProfileCollection-method}
\alias{isEmpty}
\title{Check for "empty" profiles in a SoilProfileCollection}
\usage{
\S4method{isEmpty}{SoilProfileCollection}(object, ...)
}
\arguments{
\item{object}{A SoilProfileCollection}

\item{...}{Additional arguments not used.}
}
\value{
logical. Vector of length equal to number of profiles in \code{object}. Returns \code{TRUE} when a profile has one horizon with \code{NA} top and bottom depths
}
\description{
"Empty" profiles are used as placeholders for positions in a \code{SoilProfileCollection}
These profiles result from operations that remove or extract portions of horizons
from source profiles.
}
\details{
In a \code{SoilProfileCollection} an empty profile occurs when it has one horizon,
with \code{NA} top and bottom depths. Generally all non-profile ID site and horizon-level
values are all also \code{NA}, but only the depths are checked by \code{isEmpty()}.
}
