% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ml.hz.R
\name{get.ml.hz}
\alias{get.ml.hz}
\title{Determine ML Horizon Boundaries}
\usage{
get.ml.hz(x, o.names = attr(x, which = "original.levels"))
}
\arguments{
\item{x}{\code{data.frame}, output from \code{\link[=slab]{slab()}}}

\item{o.names}{an optional character vector of horizon designations that will be used in the final table}
}
\value{
A \code{data.frame} with the following columns:
\itemize{
\item \code{hz}: horizon names
\item \code{top}: horizon top depth
\item \code{bottom}: horizon bottom depth
\item \code{confidence}: integrated probability over thickness of each ML horizon, rounded to the nearest integer
\item \code{pseudo.brier}: A "pseudo"" Brier Score for a multi-class prediction, where the most-likely horizon label is treated as the "correct" outcome. Details on the calculation for traditional Brier Scores here: \url{https://en.wikipedia.org/wiki/Brier_score}. Lower values suggest better agreement between ML horizon label and class-wise probabilities.
\item \code{mean.H}: mean Shannon entropy (bits), derived from probabilities within each most-likely horizon. Larger values suggest more confusion within each ML.
}
}
\description{
This function accepts input from \code{\link[=slab]{slab()}} (a \code{data.frame}) along with a vector of
horizon names, and returns a \code{data.frame} of the most likely horizon
boundaries.

This function expects that \code{x} is a \code{data.frame} generated by
\code{\link[=slab]{slab()}}. If \code{x} was not generated by \code{\link[=slab]{slab()}}, then \code{o.names} is required.
}
\examples{

# init SPC
data(sp1)
depths(sp1) <- id ~ top + bottom

# set horizon designation metadata
hzdesgnname(sp1) <- 'name'

# generalize horizon designations from character vector
# result is an ordered factor
sp1$genhz <- generalizeHz(
  sp1$name,
  new = c('O','A','B','C'),
  pat = c('O', '^A','^B','C'),
  ordered = TRUE
)

# compute slice-wise GHL probability
# so that it sums to contributing fraction
# from 0-150cm
a <- slab(sp1, fm = ~ genhz, cpm = 1, slab.structure = 0:150)

# note original GHL names are set by slab()
attr(a, 'original.levels')

# generate table of ML horizonation
get.ml.hz(a)

}
\references{
Beaudette, D. E., Roudier, P., & Skovlin, J. (2016). Probabilistic representation of genetic soil horizons. Digital soil morphometrics, 281-293.
}
\seealso{
\code{\link[=slab]{slab()}}
}
\author{
D.E. Beaudette
}
\keyword{manip}
