% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_validateHBControl.R
\name{apollo_validateHBControl}
\alias{apollo_validateHBControl}
\title{Validates the \code{apollo_HB} list of parameters}
\usage{
apollo_validateHBControl(
  apollo_HB,
  apollo_beta,
  apollo_fixed,
  apollo_control,
  silent = FALSE
)
}
\arguments{
\item{apollo_HB}{List. Contains options for Bayesian estimation. See \code{?RSGHB::doHB} for details.
Parameters \code{modelname}, \code{gVarNamesFixed}, \code{gVarNamesNormal},
\code{gDIST}, \code{svN} and \code{FC} are automatically set based on the
other arguments of this function.
Other settings to include are the following.
\itemize{
  \item \strong{\code{constraintsNorm}}: Character vector. Constraints for \emph{random} coefficients 
                                       in bayesian estimation. Constraints can be written as 
                                       "b1>b2", "b1<b2", "b1>0", or "b1<0".
  \item \strong{\code{fixedA}}: Named numeric vector. Contains the names and fixed mean values of 
                               random parameters. For example, c(b1=0) fixes the mean of b1 to zero.
  \item \strong{\code{fixedD}}: Named numeric vector. Contains the names and fixed variance of 
                               random parameters. For example, c(b1=1) fixes the variance of b1 to zero.
  \item \strong{\code{gFULLCV:}} Boolean. Whether the full variance-covariance structure should be used for random parameters (TRUE by default).
  \item \strong{\code{gNCREP}}: Numeric. Number of burn-in iterations to use prior to convergence (default=10^5).
  \item \strong{\code{gNEREP}}: Numeric. Number of iterations to keep for averaging after convergence has been reached (default=10^5).
  \item \strong{\code{gINFOSKIP}}: Numeric. Number of iterations between printing/plotting information about the iteration process (default=250).
  \item \strong{\code{hbDist}}: \emph{Mandatory} setting. A named character vector determining
                               the distribution of each parameter to be estimated. Possible 
                               values are as follows.
                               \itemize{
                                 \item \strong{\code{"CN+"}}: Positive censored normal.
                                 \item \strong{\code{"CN-"}}: Negative censored normal.
                                 \item \strong{\code{"JSB"}}: Johnson SB.
                                 \item \strong{\code{"LN+"}}: Positive log-normal.
                                 \item \strong{\code{"LN-"}}: Negative log-normal.
                                 \item \strong{\code{"N"}}: Normal.
                                 \item \strong{\code{"NR"}}: Fixed (as in non-random) parameter.
                               }
  \item \strong{\code{nodiagnostics}}: Boolean. Turn off pre-estimation diagnostics for RSGHB. Set to TRUE by default.
}}

\item{apollo_beta}{Named numeric vector. Names and values for parameters.}

\item{apollo_fixed}{Character vector. Names (as defined in \code{apollo_beta}) of parameters whose value should not change during estimation.
value is constant throughout estimation).}

\item{apollo_control}{List. Options controlling the running of the code. See \link{apollo_validateInputs}.}

\item{silent}{Boolean. TRUE to keep the function from printing to the console. Default is FALSE.}
}
\value{
Validated apollo_HB
}
\description{
Validates the \code{apollo_HB} list of parameters and sets default values for the omitted ones.
}
\details{
This function is only necessary when using bayesian estimation.
}
