% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{apa_style}
\alias{apa_style}
\title{Style \code{flextable::flextable} object according to APA style}
\usage{
apa_style(
  x,
  font_family = NULL,
  font_size = 12,
  text_color = "black",
  border_color = "black",
  border_width = 0.5,
  line_spacing = 2,
  horizontal_padding = 3,
  table_align = "left",
  header_align_vertical = c("top", "middle", "bottom"),
  layout = "autofit",
  table_width = 0,
  markdown = TRUE,
  markdown_header = markdown,
  markdown_body = markdown,
  no_markdown_columns = NULL,
  no_markdown_columns_header = no_markdown_columns,
  separate_headers = TRUE
)
}
\arguments{
\item{x}{object}

\item{font_family}{font family}

\item{font_size}{font size}

\item{text_color}{text color}

\item{border_color}{border color}

\item{border_width}{border width in pixels}

\item{line_spacing}{spacing between lines}

\item{horizontal_padding}{horizontal padding (in pixels)}

\item{table_align}{table alignment ("left", "center", "right")}

\item{header_align_vertical}{vertical alignment of headers. Can be "top", "middle", or "bottom"}

\item{layout}{table layout ("autofit", "fixed")}

\item{table_width}{table width (in pixels, 0 for auto)}

\item{markdown}{apply markdown formatting to header and body}

\item{markdown_header}{apply markdown formatting to header}

\item{markdown_body}{apply markdown formatting to body}

\item{no_markdown_columns}{body columns that should not be treated as markdown}

\item{no_markdown_columns_header}{column headers that should not be treated as markdown}

\item{separate_headers}{separate headers into column spanner labels}
}
\value{
object
}
\description{
Style \code{flextable::flextable} object according to APA style
}
\examples{
d <- data.frame(x = 1:3, y = 4:6)
flextable::flextable(d) |>
  apa_style()
}
