% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{add_list_column}
\alias{add_list_column}
\title{Make a column into a list column}
\usage{
add_list_column(data, ..., type = c("1", "a", "A", "I", "i"), sep = ". ")
}
\arguments{
\item{data}{data.frame or tibble}

\item{...}{Column name or tidyselect function. Select columns. Default is first column}

\item{type}{list type. Can be "1" (numeric), "a" (lowercase alphabetical), or "ABC" (uppercase alphabetical), "i" (lowercase Roman numerals), "I" (uppercase Roman numerals)}

\item{sep}{separator}
}
\value{
data.frame
}
\description{
Make a column into a list column
}
\examples{
d <- data.frame(x = letters[1:5], y = letters[2:6])
# default is first column
add_list_column(d)
# select any column
add_list_column(d, y)
add_list_column(d, type = "a", sep = ") ") |>
 apa_flextable()
}
