% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/relations.R
\docType{methods}
\name{relations}
\alias{relations}
\alias{precedes}
\alias{precedes-method}
\alias{preceded_by}
\alias{preceded_by-method}
\alias{meets}
\alias{meets-method}
\alias{met_by}
\alias{met_by-method}
\alias{overlaps}
\alias{overlaps-method}
\alias{overlapped_by}
\alias{overlapped_by-method}
\alias{finishes}
\alias{finishes-method}
\alias{finished_by}
\alias{finished_by-method}
\alias{contains}
\alias{contains-method}
\alias{during}
\alias{during-method}
\alias{starts}
\alias{starts-method}
\alias{started_by}
\alias{started_by-method}
\alias{equals}
\alias{equals-method}
\alias{precedes,TimeIntervals-method}
\alias{preceded_by,TimeIntervals-method}
\alias{preceded_by,TimeIntervals,missing-method}
\alias{meets,TimeIntervals-method}
\alias{met_by,TimeIntervals-method}
\alias{met_by,TimeIntervals,missing-method}
\alias{overlaps,TimeIntervals-method}
\alias{overlapped_by,TimeIntervals-method}
\alias{overlapped_by,TimeIntervals,missing-method}
\alias{finishes,TimeIntervals-method}
\alias{finishes,TimeIntervals,missing-method}
\alias{finished_by,TimeIntervals-method}
\alias{contains,TimeIntervals-method}
\alias{during,TimeIntervals-method}
\alias{during,TimeIntervals,missing-method}
\alias{starts,TimeIntervals-method}
\alias{starts,TimeIntervals,missing-method}
\alias{started_by,TimeIntervals-method}
\alias{started_by,TimeIntervals,missing-method}
\alias{equals,TimeIntervals-method}
\alias{equals,TimeIntervals,missing-method}
\title{Temporal Relations}
\usage{
precedes(x, ...)

preceded_by(x, ...)

meets(x, ...)

met_by(x, ...)

overlaps(x, ...)

overlapped_by(x, ...)

finishes(x, ...)

finished_by(x, ...)

contains(x, ...)

during(x, ...)

starts(x, ...)

started_by(x, ...)

equals(x, ...)

\S4method{precedes}{TimeIntervals}(x, ...)

\S4method{preceded_by}{TimeIntervals}(x, ...)

\S4method{meets}{TimeIntervals}(x, ...)

\S4method{met_by}{TimeIntervals}(x, ...)

\S4method{overlaps}{TimeIntervals}(x, ...)

\S4method{overlapped_by}{TimeIntervals}(x, ...)

\S4method{finishes}{TimeIntervals}(x, ...)

\S4method{finished_by}{TimeIntervals}(x, ...)

\S4method{contains}{TimeIntervals}(x, ...)

\S4method{during}{TimeIntervals}(x, ...)

\S4method{starts}{TimeIntervals}(x, ...)

\S4method{started_by}{TimeIntervals}(x, ...)

\S4method{equals}{TimeIntervals}(x, ...)
}
\arguments{
\item{x}{A \code{\linkS4class{TimeIntervals}} object.}

\item{...}{Currently not used.}
}
\value{
A two-columns \code{matrix} where each row specifies one relation.
}
\description{
Test for the logical relation between time intervals according to Allen's
typology.
}
\details{
Allen (1983) proposed thirteen basic relations between time intervals that
are (Alspaugh 2019):
\itemize{
\item \strong{Distinct}: no pair of definite intervals can be related by more than
one of the relationships.
\item \strong{Exhaustive:} any pair of definite intervals are described by one of the
relations.
\item \strong{Qualitative:} no numeric time spans are considered.
}

\tabular{lrlr}{
\strong{Relation} \tab     \tab     \tab  \strong{Converse} \cr
precedes     \tab (p) \tab (P) \tab   preceded by \cr
meets        \tab (m) \tab (M) \tab        met by \cr
overlaps     \tab (o) \tab (O) \tab overlapped by \cr
finished by  \tab (F) \tab (f) \tab      finishes \cr
contains     \tab (D) \tab (d) \tab        during \cr
starts       \tab (s) \tab (S) \tab    started by \cr
equals       \tab (e) \tab     \tab               \cr
}

A \emph{precedes} B

\if{html}{\out{<div class="sourceCode">}}\preformatted{A ===
B     ===
}\if{html}{\out{</div>}}

A \emph{preceded by} B

\if{html}{\out{<div class="sourceCode">}}\preformatted{A     ===
B ===
}\if{html}{\out{</div>}}

A \emph{meets} B

\if{html}{\out{<div class="sourceCode">}}\preformatted{A ===
B    ===
}\if{html}{\out{</div>}}

A \emph{met by} B

\if{html}{\out{<div class="sourceCode">}}\preformatted{A ===
B    ===
}\if{html}{\out{</div>}}

A \emph{overlaps} B

\if{html}{\out{<div class="sourceCode">}}\preformatted{A ===
B   ===
}\if{html}{\out{</div>}}

A \emph{overlapped by} B

\if{html}{\out{<div class="sourceCode">}}\preformatted{A   ===
B ===
}\if{html}{\out{</div>}}

A \emph{finished by} B

\if{html}{\out{<div class="sourceCode">}}\preformatted{A =====
B   ===
}\if{html}{\out{</div>}}

A \emph{finishes} B

\if{html}{\out{<div class="sourceCode">}}\preformatted{A   ===
B =====
}\if{html}{\out{</div>}}

A \emph{contains} B

\if{html}{\out{<div class="sourceCode">}}\preformatted{A =====
B  ===
}\if{html}{\out{</div>}}

A \emph{during} B

\if{html}{\out{<div class="sourceCode">}}\preformatted{A  ===
B =====
}\if{html}{\out{</div>}}

A \emph{starts} B

\if{html}{\out{<div class="sourceCode">}}\preformatted{A ===
B =====
}\if{html}{\out{</div>}}

A \emph{started by} B

\if{html}{\out{<div class="sourceCode">}}\preformatted{A =====
B ===
}\if{html}{\out{</div>}}

A \emph{equals} B

\if{html}{\out{<div class="sourceCode">}}\preformatted{A ===
B ===
}\if{html}{\out{</div>}}
}
\examples{
## Seven intervals
int <- intervals(
  start = c(1, 2, 3, 6, 9, 13, 17),
  end = c(7, 4, 15, 14, 11, 18, 19),
  calendar = CE(),
  names = c("A", "B", "C", "D", "E", "F", "G")
)

## Plot intervals
plot(int)

## Temporal relations
precedes(int) # A precedes E...

overlaps(int) # A overlaps C...

contains(int) # A contains B...
}
\references{
Allen, J. F. (1983). Maintaining Knowledge about Temporal Intervals.
\emph{Communications of the ACM}, 26(11): 832-843. \doi{10.1145/182.358434}.

Alspaugh, T. (2019). Allen's Interval Algebra.
URL: \url{https://thomasalspaugh.org/pub/fnd/allen.html}.
}
\seealso{
Other temporal relations: 
\code{\link{overlap}()}
}
\author{
N. Frerebeau
}
\concept{temporal relations}
