% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_test_that.R
\name{generate_embeddings}
\alias{generate_embeddings}
\title{Generate test embeddings}
\usage{
generate_embeddings(times, features, seq_len, pad_value)
}
\arguments{
\item{times}{\code{int} Maximal length of a sequence.}

\item{features}{\code{int} Number of features of the sequence.}

\item{seq_len}{Numeric \code{vector} containing the length of the given cases. The
length of this vector determines the value for 'Batch'. Values must be at least 1 and
maximal \code{times}.}

\item{pad_value}{\code{int} Value used to indicate padding.}
}
\value{
Returns an \code{array} with dim \verb{(length(seq_len),times,features)}.
}
\description{
Functions generates a random test embedding that can be used for
testing methods and functions. The embeddings have the shape
(Batch, Times,Features).
}
\note{
To generate a 'PyTorch' object please use \link{generate_tensors}.
}
\seealso{
Other Utils TestThat Developers: 
\code{\link{check_adjust_n_samples_on_CI}()},
\code{\link{generate_args_for_tests}()},
\code{\link{generate_tensors}()},
\code{\link{get_current_args_for_print}()},
\code{\link{get_fixed_test_tensor}()},
\code{\link{get_test_data_for_classifiers}()},
\code{\link{random_bool_on_CI}()}
}
\concept{Utils TestThat Developers}
