% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dotAIFEBaseTransformer.R
\name{.AIFEBaseTransformer}
\alias{.AIFEBaseTransformer}
\title{Base \code{R6} class for creation and definition of \code{.AIFE*Transformer-like} classes}
\description{
This base class is used to create and define \code{.AIFE*Transformer-like} classes. It serves as a skeleton
for a future concrete transformer and cannot be used to create an object of itself (an attempt to call \code{new}-method
will produce an error).

See p.1 Base Transformer Class in
\href{https://fberding.github.io/aifeducation/articles/transformers.html}{Transformers for Developers} for details.
}
\section{Create}{
 The \code{create}-method is a basic algorithm that is used to create a new transformer, but cannot be
called directly.
}

\section{Train}{
 The \code{train}-method is a basic algorithm that is used to train and tune the transformer but cannot be
called directly.
}

\section{Concrete transformer implementation}{
 There are already implemented concrete (child) transformers (e.g.
\code{BERT}, \code{DeBERTa-V2}, etc.), to implement a new one see p.4 Implement A Custom Transformer in
\href{https://fberding.github.io/aifeducation/articles/transformers.html}{Transformers for Developers}
}

\references{
Hugging Face transformers documantation:
\itemize{
\item \href{https://huggingface.co/docs/transformers/model_doc/bert}{BERT}
\item \href{https://huggingface.co/docs/transformers/model_doc/deberta-v2}{DeBERTa}
\item \href{https://huggingface.co/docs/transformers/model_doc/funnel}{Funnel}
\item \href{https://huggingface.co/docs/transformers/model_doc/longformer}{Longformer}
\item \href{https://huggingface.co/docs/transformers/model_doc/roberta}{RoBERTa}
\item \href{https://huggingface.co/docs/transformers/model_doc/mpnet}{MPNet}
}
}
\seealso{
Other R6 classes for transformers: 
\code{\link{.AIFEBertTransformer}},
\code{\link{.AIFEFunnelTransformer}},
\code{\link{.AIFELongformerTransformer}},
\code{\link{.AIFEMpnetTransformer}},
\code{\link{.AIFERobertaTransformer}}
}
\concept{R6 classes for transformers}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{params}}{A list containing transformer's parameters ('static', 'dynamic' and 'dependent' parameters)

\code{list()} containing all the transformer parameters. Can be set with \code{set_model_param()}.
\subsection{\strong{'Static' parameters}}{

Regardless of the transformer, the following parameters are always included:
\itemize{
\item \code{text_dataset}
\item \code{sustain_track}
\item \code{sustain_iso_code}
\item \code{sustain_region}
\item \code{sustain_interval}
\item \code{trace}
\item \code{pytorch_safetensors}
\item \code{log_dir}
\item \code{log_write_interval}
}
}

\subsection{\strong{'Dynamic' parameters}}{

In the case of \strong{create} it also contains (see \code{create}-method for details):
\itemize{
\item \code{model_dir}
\item \code{vocab_size}
\item \code{max_position_embeddings}
\item \code{hidden_size}
\item \code{hidden_act}
\item \code{hidden_dropout_prob}
\item \code{attention_probs_dropout_prob}
\item \code{intermediate_size}
\item \code{num_attention_heads}
}

In the case of \strong{train} it also contains (see \code{train}-method for details):
\itemize{
\item \code{output_dir}
\item \code{model_dir_path}
\item \code{p_mask}
\item \code{whole_word}
\item \code{val_size}
\item \code{n_epoch}
\item \code{batch_size}
\item \code{chunk_size}
\item \code{min_seq_len}
\item \code{full_sequences_only}
\item \code{learning_rate}
\item \code{n_workers}
\item \code{multi_process}
\item \code{keras_trace}
\item \code{pytorch_trace}
}
}

\subsection{\strong{'Dependent' parameters}}{

Depending on the transformer and the method used class may contain different parameters:
\itemize{
\item \code{vocab_do_lower_case}
\item \code{num_hidden_layer}
\item \code{add_prefix_space}
\item etc.
}
}}

\item{\code{temp}}{A list containing temporary transformer's parameters

\code{list()} containing all the temporary local variables that need to be accessed between the step functions. Can
be set with \code{set_model_temp()}.

For example, it can be a variable \code{tok_new} that stores the tokenizer from
\code{steps_for_creation$create_tokenizer_draft}. To train the tokenizer, access the variable \code{tok_new} in
\code{steps_for_creation$calculate_vocab} through the \code{temp} list of this class.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-.AIFEBaseTransformer-new}{\code{.AIFEBaseTransformer$new()}}
\item \href{#method-.AIFEBaseTransformer-init_transformer}{\code{.AIFEBaseTransformer$init_transformer()}}
\item \href{#method-.AIFEBaseTransformer-set_title}{\code{.AIFEBaseTransformer$set_title()}}
\item \href{#method-.AIFEBaseTransformer-set_model_param}{\code{.AIFEBaseTransformer$set_model_param()}}
\item \href{#method-.AIFEBaseTransformer-set_model_temp}{\code{.AIFEBaseTransformer$set_model_temp()}}
\item \href{#method-.AIFEBaseTransformer-set_SFC_check_max_pos_emb}{\code{.AIFEBaseTransformer$set_SFC_check_max_pos_emb()}}
\item \href{#method-.AIFEBaseTransformer-set_SFC_create_tokenizer_draft}{\code{.AIFEBaseTransformer$set_SFC_create_tokenizer_draft()}}
\item \href{#method-.AIFEBaseTransformer-set_SFC_calculate_vocab}{\code{.AIFEBaseTransformer$set_SFC_calculate_vocab()}}
\item \href{#method-.AIFEBaseTransformer-set_SFC_save_tokenizer_draft}{\code{.AIFEBaseTransformer$set_SFC_save_tokenizer_draft()}}
\item \href{#method-.AIFEBaseTransformer-set_SFC_create_final_tokenizer}{\code{.AIFEBaseTransformer$set_SFC_create_final_tokenizer()}}
\item \href{#method-.AIFEBaseTransformer-set_SFC_create_transformer_model}{\code{.AIFEBaseTransformer$set_SFC_create_transformer_model()}}
\item \href{#method-.AIFEBaseTransformer-set_required_SFC}{\code{.AIFEBaseTransformer$set_required_SFC()}}
\item \href{#method-.AIFEBaseTransformer-set_SFT_load_existing_model}{\code{.AIFEBaseTransformer$set_SFT_load_existing_model()}}
\item \href{#method-.AIFEBaseTransformer-set_SFT_cuda_empty_cache}{\code{.AIFEBaseTransformer$set_SFT_cuda_empty_cache()}}
\item \href{#method-.AIFEBaseTransformer-set_SFT_create_data_collator}{\code{.AIFEBaseTransformer$set_SFT_create_data_collator()}}
\item \href{#method-.AIFEBaseTransformer-create}{\code{.AIFEBaseTransformer$create()}}
\item \href{#method-.AIFEBaseTransformer-train}{\code{.AIFEBaseTransformer$train()}}
\item \href{#method-.AIFEBaseTransformer-clone}{\code{.AIFEBaseTransformer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBaseTransformer-new"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBaseTransformer-new}{}}}
\subsection{Method \code{new()}}{
An object of this class cannot be created. Thus, method's call will produce an error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBaseTransformer$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
This method returns an error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBaseTransformer-init_transformer"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBaseTransformer-init_transformer}{}}}
\subsection{Method \code{init_transformer()}}{
Method to execute while initializing a new transformer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBaseTransformer$init_transformer(title, init_trace)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{\code{string} A new title.}

\item{\code{init_trace}}{\code{bool} option to show prints. If \code{TRUE} (by default) - messages will be shown, otherwise
(\code{FALSE}) - hidden.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns nothing.s
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBaseTransformer-set_title"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBaseTransformer-set_title}{}}}
\subsection{Method \code{set_title()}}{
Setter for the title. Sets a new value for the \code{title} private attribute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBaseTransformer$set_title(title)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{\code{string} A new title.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBaseTransformer-set_model_param"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBaseTransformer-set_model_param}{}}}
\subsection{Method \code{set_model_param()}}{
Setter for the parameters. Adds a new parameter and its value to the \code{params} list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBaseTransformer$set_model_param(param_name, param_value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_name}}{\code{string} Parameter's name.}

\item{\code{param_value}}{\code{any} Parameter's value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBaseTransformer-set_model_temp"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBaseTransformer-set_model_temp}{}}}
\subsection{Method \code{set_model_temp()}}{
Setter for the temporary model's parameters. Adds a new temporary parameter and its value to the
\code{temp} list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBaseTransformer$set_model_temp(temp_name, temp_value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{temp_name}}{\code{string} Parameter's name.}

\item{\code{temp_value}}{\code{any} Parameter's value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBaseTransformer-set_SFC_check_max_pos_emb"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBaseTransformer-set_SFC_check_max_pos_emb}{}}}
\subsection{Method \code{set_SFC_check_max_pos_emb()}}{
Setter for the \code{check_max_pos_emb} element of the private \code{steps_for_creation} list. Sets a new
\code{fun} function as the \code{check_max_pos_emb} step.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBaseTransformer$set_SFC_check_max_pos_emb(fun)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fun}}{\verb{function()} A new function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBaseTransformer-set_SFC_create_tokenizer_draft"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBaseTransformer-set_SFC_create_tokenizer_draft}{}}}
\subsection{Method \code{set_SFC_create_tokenizer_draft()}}{
Setter for the \code{create_tokenizer_draft} element of the  private \code{steps_for_creation} list. Sets a
new \code{fun} function as the \code{create_tokenizer_draft} step.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBaseTransformer$set_SFC_create_tokenizer_draft(fun)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fun}}{\verb{function()} A new function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBaseTransformer-set_SFC_calculate_vocab"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBaseTransformer-set_SFC_calculate_vocab}{}}}
\subsection{Method \code{set_SFC_calculate_vocab()}}{
Setter for the \code{calculate_vocab} element of the private \code{steps_for_creation} list. Sets a new \code{fun}
function as the \code{calculate_vocab} step.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBaseTransformer$set_SFC_calculate_vocab(fun)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fun}}{\verb{function()} A new function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBaseTransformer-set_SFC_save_tokenizer_draft"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBaseTransformer-set_SFC_save_tokenizer_draft}{}}}
\subsection{Method \code{set_SFC_save_tokenizer_draft()}}{
Setter for the \code{save_tokenizer_draft} element of the private \code{steps_for_creation} list. Sets a new
\code{fun} function as the \code{save_tokenizer_draft} step.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBaseTransformer$set_SFC_save_tokenizer_draft(fun)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fun}}{\verb{function()} A new function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBaseTransformer-set_SFC_create_final_tokenizer"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBaseTransformer-set_SFC_create_final_tokenizer}{}}}
\subsection{Method \code{set_SFC_create_final_tokenizer()}}{
Setter for the \code{create_final_tokenizer} element of the private \code{steps_for_creation} list. Sets a new
\code{fun} function as the \code{create_final_tokenizer} step.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBaseTransformer$set_SFC_create_final_tokenizer(fun)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fun}}{\verb{function()} A new function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBaseTransformer-set_SFC_create_transformer_model"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBaseTransformer-set_SFC_create_transformer_model}{}}}
\subsection{Method \code{set_SFC_create_transformer_model()}}{
Setter for the \code{create_transformer_model} element of the private \code{steps_for_creation} list. Sets a
new \code{fun} function as the \code{create_transformer_model} step.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBaseTransformer$set_SFC_create_transformer_model(fun)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fun}}{\verb{function()} A new function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBaseTransformer-set_required_SFC"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBaseTransformer-set_required_SFC}{}}}
\subsection{Method \code{set_required_SFC()}}{
Setter for all required elements of the private \code{steps_for_creation} list. Executes setters for all
required creation steps.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBaseTransformer$set_required_SFC(required_SFC)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{required_SFC}}{\code{list()} A list of all new required steps.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBaseTransformer-set_SFT_load_existing_model"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBaseTransformer-set_SFT_load_existing_model}{}}}
\subsection{Method \code{set_SFT_load_existing_model()}}{
Setter for the \code{load_existing_model} element of the private \code{steps_for_training} list. Sets a new
\code{fun} function as the \code{load_existing_model} step.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBaseTransformer$set_SFT_load_existing_model(fun)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fun}}{\verb{function()} A new function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBaseTransformer-set_SFT_cuda_empty_cache"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBaseTransformer-set_SFT_cuda_empty_cache}{}}}
\subsection{Method \code{set_SFT_cuda_empty_cache()}}{
Setter for the \code{cuda_empty_cache} element of the private \code{steps_for_training} list. Sets a new
\code{fun} function as the \code{cuda_empty_cache} step.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBaseTransformer$set_SFT_cuda_empty_cache(fun)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fun}}{\verb{function()} A new function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBaseTransformer-set_SFT_create_data_collator"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBaseTransformer-set_SFT_create_data_collator}{}}}
\subsection{Method \code{set_SFT_create_data_collator()}}{
Setter for the \code{create_data_collator} element of the private \code{steps_for_training} list. Sets a new
\code{fun} function as the \code{create_data_collator} step. Use this method to make a custom data collator for a
transformer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBaseTransformer$set_SFT_create_data_collator(fun)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fun}}{\verb{function()} A new function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBaseTransformer-create"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBaseTransformer-create}{}}}
\subsection{Method \code{create()}}{
This method creates a transformer configuration based on the child-transformer architecture and a
vocabulary using the python libraries \code{transformers} and \code{tokenizers}.

This method \strong{adds} the following parameters to the \code{temp} list:
\itemize{
\item \code{log_file}
\item \code{raw_text_dataset}
\item \code{pt_safe_save}
\item \code{value_top}
\item \code{total_top}
\item \code{message_top}
}

This method \strong{uses} the following parameters from the \code{temp} list:
\itemize{
\item \code{log_file}
\item \code{raw_text_dataset}
\item \code{tokenizer}
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBaseTransformer$create(
  model_dir,
  text_dataset,
  vocab_size,
  max_position_embeddings,
  hidden_size,
  num_attention_heads,
  intermediate_size,
  hidden_act,
  hidden_dropout_prob,
  attention_probs_dropout_prob,
  sustain_track,
  sustain_iso_code,
  sustain_region,
  sustain_interval,
  trace,
  pytorch_safetensors,
  log_dir,
  log_write_interval
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model_dir}}{\code{string} Path to the directory where the model should be saved. Allowed values: any}

\item{\code{text_dataset}}{\code{LargeDataSetForText} \link{LargeDataSetForText} Object storing textual data.}

\item{\code{vocab_size}}{\code{int} Size of the vocabulary. Allowed values: \verb{1000 <= x <= 5e+05}}

\item{\code{max_position_embeddings}}{\code{int} Number of maximum position embeddings. This parameter also determines the maximum length of a sequence which
can be processed with the model. Allowed values: \verb{10 <= x <= 4048}}

\item{\code{hidden_size}}{\code{int} Number of neurons in each layer. This parameter determines the dimensionality of the resulting text
embedding. Allowed values: \verb{1 <= x <= 2048}}

\item{\code{num_attention_heads}}{\code{int} determining the number of attention heads for a self-attention layer. Only relevant if \code{attention_type='multihead'} Allowed values: \code{0 <= x }}

\item{\code{intermediate_size}}{\code{int} determining the size of the projection layer within a each transformer encoder. Allowed values: \code{1 <= x }}

\item{\code{hidden_act}}{\code{string} Name of the activation function. Allowed values: 'gelu', 'relu', 'silu', 'gelu_new'}

\item{\code{hidden_dropout_prob}}{\code{double} Ratio of dropout. Allowed values: \verb{0 <= x <= 0.6}}

\item{\code{attention_probs_dropout_prob}}{\code{double} Ratio of dropout for attention probabilities. Allowed values: \verb{0 <= x <= 0.6}}

\item{\code{sustain_track}}{\code{bool} If \code{TRUE} energy consumption is tracked during training via the python library 'codecarbon'.}

\item{\code{sustain_iso_code}}{\code{string} ISO code (Alpha-3-Code) for the country. This variable must be set if
sustainability should be tracked. A list can be found on Wikipedia:
\url{https://en.wikipedia.org/wiki/List_of_ISO_3166_country_codes}. Allowed values: any}

\item{\code{sustain_region}}{\code{string} Region within a country. Only available for USA and Canada See the documentation of
codecarbon for more information. \url{https://mlco2.github.io/codecarbon/parameters.html} Allowed values: any}

\item{\code{sustain_interval}}{\code{int} Interval in seconds for measuring power usage. Allowed values: \code{1 <= x }}

\item{\code{trace}}{\code{bool} \code{TRUE} if information about the estimation phase should be printed to the console.}

\item{\code{pytorch_safetensors}}{\code{bool}
\itemize{
\item \code{TRUE}: a 'pytorch' model is saved in safetensors format.
\item \code{FALSE} (or 'safetensors' is not available): model is saved in the standard pytorch format (.bin).
}}

\item{\code{log_dir}}{\code{string} Path to the directory where the log files should be saved.
If no logging is desired set this argument to \code{NULL}. Allowed values: any}

\item{\code{log_write_interval}}{`r get_param_doc_desclog_write_interval}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method does not return an object. Instead, it saves the configuration and vocabulary of the new
model to disk.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBaseTransformer-train"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBaseTransformer-train}{}}}
\subsection{Method \code{train()}}{
This method can be used to train or fine-tune a transformer based on \code{BERT} architecture with the
help of the python libraries \code{transformers}, \code{datasets}, and \code{tokenizers}.

This method \strong{adds} the following parameters to the \code{temp} list:
\itemize{
\item \code{log_file}
\item \code{loss_file}
\item \code{from_pt}
\item \code{from_tf}
\item \code{load_safe}
\item \code{raw_text_dataset}
\item \code{pt_safe_save}
\item \code{value_top}
\item \code{total_top}
\item \code{message_top}
}

This method \strong{uses} the following parameters from the \code{temp} list:
\itemize{
\item \code{log_file}
\item \code{raw_text_dataset}
\item \code{tokenized_dataset}
\item \code{tokenizer}
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBaseTransformer$train(
  output_dir,
  model_dir_path,
  text_dataset,
  p_mask,
  whole_word,
  val_size,
  n_epoch,
  batch_size,
  chunk_size,
  full_sequences_only,
  min_seq_len,
  learning_rate,
  sustain_track,
  sustain_iso_code,
  sustain_region,
  sustain_interval,
  trace,
  pytorch_trace,
  pytorch_safetensors,
  log_dir,
  log_write_interval
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{output_dir}}{\code{string} Path to the directory where the model should be saved. Allowed values: any}

\item{\code{model_dir_path}}{\code{string} Path to the directory where the original model is stored. Allowed values: any}

\item{\code{text_dataset}}{\code{LargeDataSetForText} \link{LargeDataSetForText} Object storing textual data.}

\item{\code{p_mask}}{\code{double} Ratio that determines the number of words/tokens used for masking. Allowed values: \verb{0 < x < 1}}

\item{\code{whole_word}}{\code{bool} * \code{TRUE}: whole word masking should be applied.
\itemize{
\item \code{FALSE}: token masking is used.
}}

\item{\code{val_size}}{\code{double} between 0 and 1, indicating the proportion of cases which should be
used for the validation sample during the estimation of the model.
The remaining cases are part of the training data. Allowed values: \verb{0 < x < 1}}

\item{\code{n_epoch}}{\code{int} Number of training epochs. Allowed values: \code{1 <= x }}

\item{\code{batch_size}}{\code{int} Size of the batches for training. Allowed values: \code{1 <= x }}

\item{\code{chunk_size}}{\code{int} Maximum length of every sequence. Must be equal or less the global maximum size
allowed by the model. Allowed values: \code{100 <= x }}

\item{\code{full_sequences_only}}{\code{bool} \code{TRUE} for using only chunks with a sequence length equal to \code{chunk_size}.}

\item{\code{min_seq_len}}{\code{int} Only relevant if \code{full_sequences_only = FALSE}. Value determines the minimal sequence length included in
training process.  Allowed values: \code{10 <= x }}

\item{\code{learning_rate}}{\code{double} Initial learning rate for the training. Allowed values: \verb{0 < x <= 1}}

\item{\code{sustain_track}}{\code{bool} If \code{TRUE} energy consumption is tracked during training via the python library 'codecarbon'.}

\item{\code{sustain_iso_code}}{\code{string} ISO code (Alpha-3-Code) for the country. This variable must be set if
sustainability should be tracked. A list can be found on Wikipedia:
\url{https://en.wikipedia.org/wiki/List_of_ISO_3166_country_codes}. Allowed values: any}

\item{\code{sustain_region}}{\code{string} Region within a country. Only available for USA and Canada See the documentation of
codecarbon for more information. \url{https://mlco2.github.io/codecarbon/parameters.html} Allowed values: any}

\item{\code{sustain_interval}}{\code{int} Interval in seconds for measuring power usage. Allowed values: \code{1 <= x }}

\item{\code{trace}}{\code{bool} \code{TRUE} if information about the estimation phase should be printed to the console.}

\item{\code{pytorch_trace}}{``r get_param_doc_desc("pytorch_trace")`}

\item{\code{pytorch_safetensors}}{\code{bool}
\itemize{
\item \code{TRUE}: a 'pytorch' model is saved in safetensors format.
\item \code{FALSE} (or 'safetensors' is not available): model is saved in the standard pytorch format (.bin).
}}

\item{\code{log_dir}}{\code{string} Path to the directory where the log files should be saved.
If no logging is desired set this argument to \code{NULL}. Allowed values: any}

\item{\code{log_write_interval}}{`r get_param_doc_desclog_write_interval}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method does not return an object. Instead, it saves the configuration and vocabulary of the new
model to disk.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBaseTransformer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBaseTransformer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBaseTransformer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
