% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIFETransformerMaker.R
\name{aife_transformer.load_model_config}
\alias{aife_transformer.load_model_config}
\title{Load a model configuration}
\usage{
aife_transformer.load_model_config(type, model_dir)
}
\arguments{
\item{type}{\code{string} A type of the transformer. Allowed types are bert, roberta, funnel, longformer, mpnet, modernbert. See
\link{AIFETrType} list.}

\item{model_dir}{\code{string} Path to the directory where the original model is stored. Allowed values: any}
}
\value{
If success - a model configuration, otherwise - an error (passed type is invalid).
}
\description{
Loads a configuration for a transformer with the passed type.
}
\seealso{
Other Transformers for developers: 
\code{\link{.AIFEModernBertTransformer}},
\code{\link{.AIFETrConfig}},
\code{\link{.AIFETrModel}},
\code{\link{.AIFETrModelMLM}},
\code{\link{.AIFETrObj}},
\code{\link{.AIFETrTokenizer}},
\code{\link{.aife_transformer.check_type}()},
\code{\link{aife_transformer.load_model}()},
\code{\link{aife_transformer.load_model_mlm}()},
\code{\link{aife_transformer.load_tokenizer}()}
}
\concept{Transformers for developers}
\keyword{internal}
