% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afmReadVeecoFolder.R
\name{afmReadVeecoFolder}
\alias{afmReadVeecoFolder}
\title{Read all Bruke Nanoscope Veeco ascii files in a folder}
\usage{
afmReadVeecoFolder(folder, pattern = ".txt", ...)
}
\arguments{
\item{folder}{Name of the  folder containing the Veeco files.}

\item{pattern}{Pattern that will identify the Veeco files (".txt" by default).}

\item{...}{Parameters to be passed to the afmReadVeeco() function.}
}
\value{
An \code{afmexperiment} class data structure with all F-d curves.
}
\description{
Read all Veeco ascii files in a given folder. It searches for all files containing a 
given patter (".txt" by default) and uses the \code{afmReadVeeco} function.
}
\examples{
folder <- paste(path.package("afmToolkit"), "veecoFolder",sep = "/")
data <- afmReadVeecoFolder(folder = folder)
str(data)
}
