% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_fever_records.R
\name{derive_fever_records}
\alias{derive_fever_records}
\title{Creating Fever Records}
\usage{
derive_fever_records(dataset, dataset_source, filter_source, faobj)
}
\arguments{
\item{dataset}{Input Dataset
Input dataset is expected to have variables \code{USUBJID} and \code{FAOBJ}.}

\item{dataset_source}{Source Dataset - SDTM Vital Sign (\code{VS})
Source Dataset (VS) is expected to have temperature records.}

\item{filter_source}{Filter condition for Source dataset.}

\item{faobj}{FAOBJ Value for fever records in output dataset.}
}
\value{
The output dataset contains records with \code{FATESTCD = "OCCUR"} for
\code{FAOBJ = FEVER} records.
}
\description{
Creating Fever records from the \code{VS} SDTM dataset.
}
\details{
Check if \code{FAOBJ = FEVER} record is present in input dataset,
if not then use \code{SDTM.VS} to get FEVER records.
With temperature values from \code{VSSTRESN} we decide if FEVER has
occurred or not (\code{FAORRES = "Y"/"N"}).
Since records are derived, these FEVER records are considered \code{DTYPE = "DERIVED"}
if \code{FAOBJ = FEVER} record is present, then input dataset will be made as output with no further
analysis.

The temperature value greater or equal 38° C will be considered as FEVER records.
}
\examples{
library(tibble)
library(dplyr)
library(admiraldev)
library(admiral)

input <- tribble(
  ~USUBJID, ~FAOBJ, ~FATESTCD, ~FACAT, ~FASCAT, ~FATPT,
  "ABC101", "REDNESS", "SEV", "REACTOGENICITY", "ADMINISTRATIVE SITE", "DAY 1",
  "ABC101", "REDNESS", "DIAM", "REACTOGENICITY", "ADMINISTRATIVE SITE", "DAY 2",
  "ABC101", "VOMITTING", "SEV", "REACTOGENICITY", "SYSTEMIC", "DAY 1",
  "ABC101", "FATIQUE", "OCCUR", "REACTOGENICITY", "SYSTEMIC", "DAY 3"
)

vs <- tribble(
  ~USUBJID, ~VSTESTCD, ~VSCAT, ~VSSTRESN, ~VSSTRESU, ~VSTPT,
  "ABC101", "TEMP", "REACTOGENICITY", 38.3, "C", "DAY 1",
  "ABC101", "TEMP", "REACTOGENICITY", 38, "C", "DAY 2",
  "ABC101", "TEMP", "REACTOGENICITY", 36, "C", "DAY 3",
  "ABC101", "TEMP", "REACTOGENICITY", 37, "C", "DAY 4",
  "ABC101", "TEMP", "REACTOGENICITY", 39, "C", "DAY 5",
  "ABC101", "TEMP", "REACTOGENICITY", 39, "C", "DAY 6",
  "ABC101", "TEMP", "REACTOGENICITY", 38, "C", "DAY 7"
)

derive_fever_records(
  dataset = input,
  dataset_source = vs,
  filter_source = VSCAT == "REACTOGENICITY" & VSTESTCD == "TEMP",
  faobj = "FEVER"
)

}
\seealso{
Other der_rec: 
\code{\link{derive_diam_to_sev_records}()}
}
\author{
Dhivya Kanagaraj
}
\concept{der_rec}
\keyword{der_rec}
