% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_centiloid.R
\name{compute_centiloid}
\alias{compute_centiloid}
\title{Compute Centiloid Value}
\usage{
compute_centiloid(
  tracer,
  pipeline,
  ref_region,
  suvr,
  custom_slope = NULL,
  custom_intercept = NULL
)
}
\arguments{
\item{tracer}{Amyloid PET tracer

A character string is expected.
If \code{custom_slope} and \code{custom_intercept} are specified, this parameter is ignored.
See Details section for accepted values in combination with \code{pipeline} and \code{ref_region}.}

\item{pipeline}{SUVR pipeline

A character string is expected.
If \code{custom_slope} and \code{custom_intercept} are specified, this parameter is ignored.
See Details section for accepted values in combination with \code{tracer} and \code{ref_region}.}

\item{ref_region}{Reference region

A character string is expected.
If \code{custom_slope} and \code{custom_intercept} are specified, this parameter is ignored.
See Details section for accepted values in combination with \code{tracer} and \code{ref_region}.}

\item{suvr}{SUVR value

A numeric value is expected.}

\item{custom_slope}{Optional slope parameter for custom Centiloid calculation formula

A numeric value is expected when provided.
When \code{custom_slope} is specified (along with \code{custom_intercept}), this overrides
the standard formula parameters \code{tracer}, \code{pipeline}, and \code{ref_region}.
Default is \code{NULL}.}

\item{custom_intercept}{Optional intercept parameter for custom centiloid calculation formula

A numeric value is expected when provided.
When \code{custom_intercept} is specified (along with \code{custom_slope}), this overrides
the standard formula parameters \code{tracer}, \code{pipeline}, and \code{ref_region}.
Default is \code{NULL}.}
}
\value{
A numeric Centiloid value.
}
\description{
Computes the Centiloid value based on an amyloid Positron Emission Tomography (PET)
scan radioactive tracer, Standardized Uptake Value Ratio (SUVR) value, pipeline,
and reference region.
Also allows for custom formula parameters.
}
\details{
The Centiloid scale is a standardized quantitative measure for amyloid PET imaging
that allows comparison between different tracers and analysis methods. This function
converts SUVR values to the Centiloid scale based on published conversion
equations for specific tracer, pipeline, and reference region combinations.

Centiloid is calculated as:

\deqn{Centiloid = slope \times SUVR + intercept}

where slope and intercept are formula parameters. If \code{custom_slope} and \code{custom_intercept}
are not specified, this function uses pre-defined slope and intercept based on
the user's selections of tracer, pipeline, and reference region.

The combinations of tracer, pipeline and reference region in the table below are supported. The
columns "slope" and "intercept" then show the values of the slope and intercept that
\code{compute_centiloid()} will use to calculate the centiloid value in each case.\tabular{lllll}{
   tracer \tab pipeline \tab ref_region \tab slope \tab intercept \cr
   18F-Florbetapir \tab AVID FBP SUVR PIPELINE¹ \tab Whole Cerebellum \tab 183.07 \tab -177.26 \cr
   18F-Florbetaben \tab AVID FBB SUVR PIPELINE² \tab Whole Cerebellum \tab 156.06 \tab -148.13 \cr
   18F-Florbetapir \tab BERKELEY FBP SUVR PIPELINE³ \tab Whole Cerebellum \tab 188.22 \tab -189.16 \cr
   18F-Florbetaben \tab BERKELEY FBB SUVR PIPELINE³ \tab Whole Cerebellum \tab 157.15 \tab -151.87 \cr
}


The equations used for the conversions are based on the following references:

¹ Navitsky, et al. (2018). \doi{10.1016/j.jalz.2018.06.1353}
² Sims, et al. (2024). \doi{10.1001/jama.2023.13239}
³ Royse, et al. (2021). \doi{10.1186/s13195-021-00836-1}

Alternatively, the user can override the pre-selection by specifying both \code{custom_slope}
and \code{custom_intercept} instead. When \code{custom_slope} and \code{custom_intercept} are specified,
the function ignores \code{tracer}, \code{pipeline} and \code{ref_region} for calculation purposes. However,
this function \strong{always requires} specification of \code{tracer}, \code{pipeline}, and \code{ref_region}
parameters, even when using custom slope and intercept values. This design choice ensures
that users remain cognizant of the imaging context and analysis methodology when computing
Centiloid values.

For additional Centiloid transformation formulas, see:
Iaccarino, L. et al. (2025). \doi{10.1016/j.nicl.2025.103765}

If a matching combination of tracer, pipeline, and reference region is not specified and both
\code{custom_slope} and \code{custom_intercept} are not specified, the function aborts with an error.
}
\examples{
# Using standard parameters
compute_centiloid(
  tracer = "18F-Florbetapir",
  pipeline = "AVID FBP SUVR PIPELINE",
  ref_region = "Whole Cerebellum",
  suvr = 1.25
)

# Using custom parameters
compute_centiloid(
  tracer = "MyTracer",
  pipeline = "MyPipeline",
  ref_region = "MyRegion",
  suvr = 1.25,
  custom_slope = 193,
  custom_intercept = -187
)
}
\concept{com_bds_findings}
\keyword{com_bds_findings}
