% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorial_plan.R
\name{fp_add_scale}
\alias{fp_add_scale}
\title{Scale factors levels}
\usage{
fp_add_scale(dm, ..., suffix = "_s")
}
\arguments{
\item{dm}{the design matrix to scale.}

\item{...}{a set of factors to scale, with their respective ranges, e.g.
\verb{A=c(10, 30), B=c(0, 1)}.if the range is not a two-number vector or the
factor is not numeric, a warning is printed and the factor is skipped.}

\item{suffix}{the suffix to add to the scaled factor name in creating new
columns. If the suffix is the empty string, factors are replaced.}
}
\value{
the design matrix with the scaled factors.
}
\description{
This function allows to add columns to a design matrix with scaled factor,
i.e. factors reported in real units rather in coded units (e.g. -1, 1).
}
\examples{
fp_design_matrix(3, rep=2) \%>\%
  fp_add_scale(A=c(10, 30), B=c(0, 1), suffix=".scaled")
}
