% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acled_deletions_api.R
\name{acled_deletions_api}
\alias{acled_deletions_api}
\title{Request data from the ACLED Deletions API}
\usage{
acled_deletions_api(email = NULL, password = NULL, date_deleted = NULL)
}
\arguments{
\item{email}{character string. Email associated with your ACLED account registered at \url{https://developer.acleddata.com}.}

\item{password}{character string. The password associated with your ACLED account. If NULL, you will be prompted to enter your password interactively.}

\item{date_deleted}{character string. Format 'yyyy-mm-dd' or Unix timestamp. The query will return all deleted events including and after the requested date/timestamp.}
}
\value{
Returns a tibble of ACLED data with columns for event_id_cnty and deleted_timestamp.
}
\description{
This function allows users to pull deleted ACLED event IDs from the Deletions API.
}
\examples{
\dontrun{

# Request deleted ACLED events since January 1, 2022
acled_deletions_api(date_deleted = "2022-01-01")
}
}
\seealso{
\itemize{
\item \href{https://acleddata.com/api-documentation/deleted-endpoint}{ACLED API deleted endpoint}
}

Other API and Access: 
\code{\link{acled_api}()},
\code{\link{acled_auth}()},
\code{\link{acled_update}()}
}
\concept{API and Access}
