% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ab_scenario.R
\name{ab_json}
\alias{ab_json}
\title{Convert geographic ('sf') representation of OD data to 'JSON list' structure}
\usage{
ab_json(
  desire_lines,
  mode_column = NULL,
  time_fun = ab_time_normal,
  scenario_name = "test",
  default_purpose = "Work",
  ...
)
}
\arguments{
\item{desire_lines}{OD data represented as geographic lines created by
\code{\link[=ab_scenario]{ab_scenario()}}.}

\item{mode_column}{The column name in the desire lines data that contains
the mode of transport. \code{"mode_baseline"} by default.}

\item{time_fun}{The function used to calculate departure times.
\code{ab_time_normal()} by default.}

\item{scenario_name}{The name of the scenario to appear in A/B Street.
The default value is \code{"test"}, which generates a message to tell you to
think of a more imaginative scenario name!}

\item{default_purpose}{In case a \code{purpose} column is not present in the input,
or there are missing values in the \code{purpose} column, this argument sets
the default, fallback purpose, as \code{"Work"} by default, reflecting the
prevalence of work-based data and thinking in transport models.}

\item{...}{Additional arguments to pass to \code{\link[=ab_json]{ab_json()}}}
}
\value{
A list that can be saved as a JSON file with \code{\link[=ab_save]{ab_save()}}
}
\description{
This function takes outputs from \code{\link[=ab_scenario]{ab_scenario()}} and returns a list that
can be saved as a JSON file for import into A/B Street.
}
\details{
Note: the departure time in seconds is multiplied by 10000 on conversion
to a .json list object for compatibility with the A/B Street schema.
}
\examples{
# Starting with tabular data
od = leeds_od
od[[1]] = c("E02006876")
zones = leeds_zones
ablines = ab_scenario(od, zones = zones)
ab_list = ab_json(ablines, mode_column = "mode", scenario_name = "test")
ab_list$scenario
f = tempfile(fileext = ".json")
ab_save(ab_list, f)
readLines(f)[1:30]

# Starting with JSON data from A/B Street (multiple trips per person)
f = system.file("extdata/minimal_scenario2.json", package = "abstr")
desire_lines = ab_sf(f)
desire_lines
json_list = ab_json(desire_lines)
json_list
}
