% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aRD.R
\name{aRD}
\alias{aRD}
\title{Adjusted Risk differences via specifically penalized likelihood}
\usage{
aRD(formula, data, maxit = 80000L, solver = "quadprog",
verbose = FALSE, polish_final = TRUE, eps_abs = 1e-5, 
eps_rel = 1e-5, conswitch = 1, use_nearPD = TRUE)
}
\arguments{
\item{formula}{An object of class \code{"formula"} (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{A data frame containing the variables in the model.}

\item{maxit}{A positive integer giving the maximum number of iterations.}

\item{solver}{A character string specifying the solver to use. Options are "osqp" () or "quadprog" ().}

\item{verbose}{Logical; if TRUE, a detailed output is printed, including iteration logs, armijo steps,
objective values and solver messages (e.g., from \code{osqp}).}

\item{polish_final}{Logical; if TRUE and solver is "osqp", performs a final polish step.}

\item{eps_abs}{Absolute tolerance for solver convergence (only used with "osqp").}

\item{eps_rel}{Relative tolerance for solver convergence (only used with "osqp").}

\item{conswitch}{Specifies how the constraint matrix is constructed:
\describe{
  \item{1 (default)}{Generates all possible combinations of minimum and maximum values for the predictors (excluding the intercept), resulting in \eqn{2^{m-1}} constraints. 
  This formulation constrains model predictions within the observed data range, making it suitable for both risk factor identification and prediction (prognosis).}
  \item{0}{Uses the raw design matrix \code{x} as the constraint matrix, resulting in \eqn{n} constraints. 
  This is primarily suitable for identifying risk factors, but not for prediction tasks, as predictions are not bounded to realistic ranges.}
}}

\item{use_nearPD}{Logical; if \code{TRUE}, the Hessian matrix is projected to the nearest positive definite matrix 
using \code{Matrix::nearPD()} to ensure numerical stability, especially when using solvers that require a positive definite matrix 
(e.g., \code{quadprog}). If \code{FALSE}, the raw Hessian is used directly, which is faster but may lead to numerical issues 
if the matrix is not positive definite. Default is \code{TRUE}.}
}
\value{
An object of S4 class \code{"aRD"} containing the following slots:
\item{call}{An object of class \code{"call"}.}
\item{formula}{An object of class \code{"formula"}.}
\item{coefficients}{A numeric vector containing the estimated model parameters.}
\item{iter}{A positive integer indicating the number of iterations.}
\item{converged}{A logical constant that indicates whether the model has converged.}
\item{y}{A numerical vector containing the dependent variable of the model.}
\item{x}{The model matrix.}
\item{data}{A data frame containing the variables in the model.}
}
\description{
\code{aRD()} fits a linear-binomial model using a modified Newton-type algorithm (aRD algorithm) for solving the maximum likelihood estimation problem under linear box constraints.
}
\examples{
set.seed(123)
n <- 100
x <- rnorm(n, 50, 1)
y <- rbinom(n, 1, -1.5 + 0.04 * x)
fit <- aRD(formula = y ~ x, data = data.frame(y = y, x = x), 
solver = "quadprog", verbose = TRUE, maxit = 80000L, conswitch = 1)
summary(fit)
}
\references{
Wagenpfeil S, Schöpe J, Bekhit A (2025) Estimation of adjusted relative risks in log-binomial regression using the BSW algorithm. In: Mau J, Mukhin S, Wang G, Xu S (Eds.) Biokybernetika. DE GRUYTER, Berlin, Germany, pp. 665–676.
Wagenpfeil S (1991) Implementierung eines SQP-Verfahrens mit dem Algorithmus von Ritter und Best. Diplomarbeit, TUM, Munich, Germany
Stellato B, Banjac G, Goulart P, Boyd S, Bansal V (2024). *osqp: Quadratic Programming Solver using the 'OSQP' Library*. R package version 0.6.3.3. \doi{10.32614/CRAN.package.osqp}. Available at: \url{https://CRAN.R-project.org/package=osqp}.
Turlach BA, Weingessel A, Moler C (2019). *quadprog: Functions to Solve Quadratic Programming Problems*. R package version 1.5-8. \doi{10.32614/CRAN.package.quadprog}. Available at: \url{https://CRAN.R-project.org/package=quadprog}.
}
\author{
Thomas Wolf, Julius Johannes Weise, Stefan Wagenpfeil
}
