\name{weibayes.mle}
\alias{weibayes.mle}

\title{
    Fitting for Minimal Failure Datasets using likelihood optimization
}

\description{
    An optimized search method for "1-parameter Weibull" modeling based on a "prior" known beta, or eta value. 
}

\usage{
weibayes.mle(x, beta=NULL, eta=NULL, incr=1e-7, listout=FALSE)
}

\arguments{
  \item{x}{A dataframe such as generated by mleframe with column names 'left', 'right' and optionally 'qty'.
    Exact failure data (occurrences) have same time entered in both 'left' and 'right' columns.
	Suspension data has last known life[time] entered in 'left' column and -1 entered in 'right' column.
	The left(early) interval bound for left-censored data must be entered as zero. (NA is not accepted).
  }
    \item{beta}{
        A weibull shape parameter based on prior like kind study.
    }
    \item{eta}{
        A weibull scope parameter based on prior like kind study.
    }
    \item{incr}{
        An increment used to establish the slope of the contour at given points.
    }
    \item{listout}{
        A logical determining whether details of the optimization loop should be presented in a list output. (For debugging purposes.)
    }
}

\value{
    Returns either the Weibull scale, Eta, paramater value if known beta is provided, 
    or the Weibull shape, Beta, parameter if knonw eta is provided.
}

\details{
   This function searches the contour map to identify the local maximum liklihood on a given axis through the contour. 
   Since this function takes the lrq_frame for data input, it will handle interval data as well as exact time failures and suspensions.
   This function has been written in pure R, hence, is expected to be too slow for production work. It is intended to be usefull
   as a study tool.
   }

\examples{
fail<-5
susp<-rweibull(10, 1, 10)
eta<-weibayes.mle(mleframe(fail, susp), beta=1)
}