% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculator_f.R
\name{rcond_gompertz}
\alias{rcond_gompertz}
\title{Draw from a conditional Gompertz distribution (lower bound only)}
\usage{
rcond_gompertz(n = 1, shape, rate, lower_bound = 0, seed = NULL)
}
\arguments{
\item{n}{The number of observations to be drawn}

\item{shape}{The shape parameter of the Gompertz distribution, defined as in the coef() output on a flexsurvreg object}

\item{rate}{The rate parameter of the Gompertz distribution, defined as in the coef() output on a flexsurvreg object}

\item{lower_bound}{The lower bound of the conditional distribution}

\item{seed}{An integer which will be used to set the seed for this draw.}
}
\value{
Estimate(s) from the conditional Gompertz distribution based on given parameters
}
\description{
Draw from a conditional Gompertz distribution (lower bound only)
}
\examples{
rcond_gompertz(1,shape=0.05,rate=0.01,lower_bound = 50)
}
