% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculator_f.R
\name{pcond_gompertz}
\alias{pcond_gompertz}
\title{Survival Probaility function for conditional Gompertz distribution (lower bound only)}
\usage{
pcond_gompertz(time = 1, shape, rate, lower_bound = 0)
}
\arguments{
\item{time}{Vector of times}

\item{shape}{The shape parameter of the Gompertz distribution, defined as in the coef() output on a flexsurvreg object}

\item{rate}{The rate parameter of the Gompertz distribution, defined as in the coef() output on a flexsurvreg object}

\item{lower_bound}{The lower bound of the conditional distribution}
}
\value{
Estimate(s) from the conditional Gompertz distribution based on given parameters
}
\description{
Survival Probaility function for conditional Gompertz distribution (lower bound only)
}
\examples{
pcond_gompertz(time=1,shape=0.05,rate=0.01,lower_bound = 50)
}
