% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{Kappa3GF}
\alias{Kappa3GF}
\title{Kappa3 distribution growth factors}
\usage{
Kappa3GF(lcv, lskew, RP)
}
\arguments{
\item{lcv}{linear coefficient of variation}

\item{lskew}{linear skewness}

\item{RP}{return period}
}
\value{
Kappa3 distribution estimated growth factor
}
\description{
Estimated growth factors as a function of return period, with inputs of Lcv & LSkew (linear coefficient of variation & linear skewness)
}
\details{
Growth factors are calculated by the method outlined in Kjeldsen, T (2019), 'The 3-parameter Kappa distribution as an alternative for use with FEH pooling groups.'Circulation - The Newsletter of the British Hydrological Society, no. 142
}
\examples{
# Get an ungauged pooled Lcv and LSkew for catchment 15006
pooled_res <- as.numeric(QuickResults(GetCDs(15006), plot = FALSE)[[2]])

# Calculate Kappa growth factor for the 100-year flood
Kappa3GF(pooled_res[1], pooled_res[2], RP = 100)

}
\author{
Anthony Hammond
}
