% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{GenParetoEst}
\alias{GenParetoEst}
\title{Generalised Pareto distribution estimates from parameters}
\usage{
GenParetoEst(loc, scale, shape, q = NULL, RP = 100, ppy = 1)
}
\arguments{
\item{loc}{location parameter}

\item{scale}{scale parameter}

\item{shape}{shape parameter}

\item{q}{quantile. magnitude of the variable under consideration}

\item{RP}{return period}

\item{ppy}{peaks per year. Default is one}
}
\value{
quantile as a function of RP or vice versa
}
\description{
Estimated quantiles as function of return period (RP) and vice versa, from user input parameters
}
\details{
If the argument q is used, it overrides RP and provides RP as a function of q (magnitude of variable) as opposed to q as a function of RP. The average number of peaks per year argument (ppy) is necessary when ppy is not equal to 1.

This function applies a probability distribution model which assumes that the sample data is independent and identical, i.e. the assumption is that all observations in the sample would not impact or depend on any other. Furthermore, all observations are from the same underlying process which has not changed over the period of record (stationarity).
}
\examples{
# Get a POT sample, estimate the parameters, and estimate the 50-year RP
thames_pot <- POTextract(ThamesPQ[, c(1, 3)], thresh = 0.90)
GenParetoPars(thames_pot$peak)

# Store the parameters in an object
pars <- as.numeric(GenParetoPars(thames_pot$peak))

# Get an estimate of 50-year flow
GenParetoEst(pars[1], pars[2], pars[3], ppy = 1.867, RP = 50)

# Estimate the RP for a 600 m^3/s discharge
GenParetoEst(pars[1], pars[2], pars[3], ppy = 1.867, q = 600)

}
\author{
Anthony Hammond
}
