% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETSestim.R
\name{ETSestim}
\alias{ETSestim}
\title{ETSestim}
\usage{
ETSestim(m)
}
\arguments{
\item{m}{an object of type \code{ETS} created with \code{ETSforecast}}
}
\value{
The same input object with the appropriate fields 
filled in, in particular:
\item{p}{Estimated parameters}
\item{yFor}{Forecasted values of output}
\item{yForV}{Variance of forecasted values of output}
\item{ySimul}{Bootstrap simulations for forecasting distribution evaluation}
}
\description{
Estimates and forecasts ETS models
}
\details{
\code{ETSestim} estimates and forecasts a time series using an
an ETS model
}
\examples{
\dontrun{
m1 <- ETSsetup(log(gdp))
m1 <- ETSestim(m1)
}
}
\seealso{
\code{\link{ETS}}, \code{\link{ETSforecast}}, \code{\link{ETSvalidate}},
         \code{\link{ETScomponents}}
}
\author{
Diego J. Pedregal
}
