#' Nakaya (1997)
#'
#' @description Nakaya, T. (1997) Statistical inferences in bidimensional regression models. Geographical Analysis, 29(2), 169-186.
#'
#' @source \doi{10.1111/j.1538-4632.1997.tb00954.x}
#' @format A data frame with 19 observations on the following 4 variables:
#' \describe{
#'   \item{depV1, depV2}{numeric vectors, dependent variables}
#'   \item{indepV1, indepV2}{numeric vectors, independent variables}
#' }
"NakayaData"

#' Eye gaze calibration data
#'
#' A dataset containing a monocular eye gaze recording with calibration sequence.
#' Courtesy of \href{https://www.uni-bamberg.de/entwicklungspsychologie/transfer/babyforschung-bambi/}{Bamberger Baby Institut: BamBI}.
#'
#' @source \url{https://www.uni-bamberg.de/entwicklungspsychologie/transfer/babyforschung-bambi/}.
#' @format A data frame with 365 rows and 6 variables:
#' \describe{
#'   \item{time}{sample timestamp, in milliseconds}
#'   \item{x, y}{recorded gaze, in internal eye tracker units}
#'   \item{target_x, target_y}{location of the calibration target on the screen, in pixels}
#'   \item{target}{index of the target within the sequence}
#' }
"EyegazeData"


#' Friedman & Kohler (2003), data set #1
#'
#' @description Data from Friedman, A., & Kohler, B. (2003). Bidimensional regression: Assessing
#' the configural similarity and accuracy of cognitive maps and other two-dimensional data sets.
#' Psychological Methods, 8(4), 468-491. DOI: 10.1037/1082-989X.8.4.468
#'
#' @source \doi{10.1037/1082-989X.8.4.468}
#' @format A data frame with 4 observations on the following 4 variables:
#' \describe{
#'   \item{depV1, depV2}{numeric vectors, dependent variables}
#'   \item{indepV1, indepV2}{numeric vectors, independent variables}
#' }
"FriedmanKohlerData1"

#' Friedman & Kohler (2003), data set #2
#'
#' @description Data from Friedman, A., & Kohler, B. (2003). Bidimensional regression: Assessing
#' the configural similarity and accuracy of cognitive maps and other two-dimensional data sets.
#' Psychological Methods, 8(4), 468-491. DOI: 10.1037/1082-989X.8.4.468
#'
#' @source \doi{10.1037/1082-989X.8.4.468}
#' @format A data frame with 4 observations on the following 4 variables:
#' \describe{
#'   \item{depV1, depV2}{numeric vectors, dependent variables}
#'   \item{indepV1, indepV2}{numeric vectors, independent variables}
#' }
"FriedmanKohlerData2"


#' Carbon, C. C. (2013), data set #1
#'
#' @description Example 1 from the domain of aesthetics to show how the method can be utilized
#' for assessing the similarity of two portrayed persons, actually the Mona Lisa in the world
#' famous Louvre version and the only recently re-discovered Prado version.
#'
#' @source \doi{10.18637/jss.v052.c01}
#' @format A data frame with 36 observations on the following 4 variables:
#' \describe{
#'   \item{depV1, depV2}{numeric vectors, dependent variables}
#'   \item{indepV1, indepV2}{numeric vectors, independent variables}
#' }
"CarbonExample1Data"

#' Carbon, C. C. (2013), data set #2
#'
#' @description Example 2 originates from the area of geography and inspects the accuracy of
#' different maps of the city of Paris which were created over the last 350 years as compared
#' to a recent map.
#'
#' @source \doi{10.18637/jss.v052.c01}
#' @format A data frame with 13 observations on the following 4 variables:
#' \describe{
#'   \item{depV1, depV2}{numeric vectors, dependent variables}
#'   \item{indepV1, indepV2}{numeric vectors, independent variables}
#' }
"CarbonExample2Data"

#' Carbon, C. C. (2013), data set #3
#'
#' @description Example 3 focuses on demonstrating how good a cognitive map recalculated from
#' averaged cognitive distance data fits with a related real map.
#'
#' @source \doi{10.18637/jss.v052.c01}
#' @format A data frame with 10 observations on the following 4 variables:
#' \describe{
#'   \item{depV1, depV2}{numeric vectors, dependent variables}
#'   \item{indepV1, indepV2}{numeric vectors, independent variables}
#' }
"CarbonExample3Data"

#' Face landmarks, female, #070
#'
#' @source Carbon, C. C. (2012). The Bamberg DADA Face Database (BaDADA). A standardized high quality Face Database with faces of Different Affective states from Different Angles. Unpublished databank. University of Bamberg, Bamberg.
#' @format A data frame with 64 landmarks on the following 3 variables:
#' \describe{
#'   \item{x, y, z}{numeric vectors, coordinates of face landmarks}
#' }
"Face3D_W070"

#' Face landmarks, female, #097
#'
#' @source Carbon, C. C. (2012). The Bamberg DADA Face Database (BaDADA). A standardized high quality Face Database with faces of Different Affective states from Different Angles. Unpublished databank. University of Bamberg, Bamberg.
#' @format A data frame with 64 landmarks on the following 3 variables:
#' \describe{
#'   \item{x, y, z}{numeric vectors, coordinates of face landmarks}
#' }
"Face3D_W097"

#' Face landmarks, female, #182
#'
#' @source Carbon, C. C. (2012). The Bamberg DADA Face Database (BaDADA). A standardized high quality Face Database with faces of Different Affective states from Different Angles. Unpublished databank. University of Bamberg, Bamberg.
#' @format A data frame with 64 landmarks on the following 3 variables:
#' \describe{
#'   \item{x, y, z}{numeric vectors, coordinates of face landmarks}
#' }
"Face3D_W182"


#' Face landmarks, female, #243
#'
#' @source Carbon, C. C. (2012). The Bamberg DADA Face Database (BaDADA). A standardized high quality Face Database with faces of Different Affective states from Different Angles. Unpublished databank. University of Bamberg, Bamberg.
#' @format A data frame with 64 landmarks on the following 3 variables:
#' \describe{
#'   \item{x, y, z}{numeric vectors, coordinates of face landmarks}
#' }
"Face3D_W243"


#' Face landmarks, male, #010
#'
#' @source Carbon, C. C. (2012). The Bamberg DADA Face Database (BaDADA). A standardized high quality Face Database with faces of Different Affective states from Different Angles. Unpublished databank. University of Bamberg, Bamberg.
#' @format A data frame with 64 landmarks on the following 3 variables:
#' \describe{
#'   \item{x, y, z}{numeric vectors, coordinates of face landmarks}
#' }
"Face3D_M010"

#' Face landmarks, male, #092
#'
#' @source Carbon, C. C. (2012). The Bamberg DADA Face Database (BaDADA). A standardized high quality Face Database with faces of Different Affective states from Different Angles. Unpublished databank. University of Bamberg, Bamberg.
#' @format A data frame with 64 landmarks on the following 3 variables:
#' \describe{
#'   \item{x, y, z}{numeric vectors, coordinates of face landmarks}
#' }
"Face3D_M92"

#' Face landmarks, male, #101
#'
#' @source Carbon, C. C. (2012). The Bamberg DADA Face Database (BaDADA). A standardized high quality Face Database with faces of Different Affective states from Different Angles. Unpublished databank. University of Bamberg, Bamberg.
#' @format A data frame with 64 landmarks on the following 3 variables:
#' \describe{
#'   \item{x, y, z}{numeric vectors, coordinates of face landmarks}
#' }
"Face3D_M101"

#' Face landmarks, male, #244
#'
#' @source Carbon, C. C. (2012). The Bamberg DADA Face Database (BaDADA). A standardized high quality Face Database with faces of Different Affective states from Different Angles. Unpublished databank. University of Bamberg, Bamberg.
#' @format A data frame with 64 landmarks on the following 3 variables:
#' \describe{
#'   \item{x, y, z}{numeric vectors, coordinates of face landmarks}
#' }
"Face3D_M244"
