% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPR.R
\name{SPR}
\alias{SPR}
\alias{SPRMoves}
\alias{SPRMoves.phylo}
\alias{SPRMoves.matrix}
\alias{SPRSwap}
\alias{RootedSPR}
\alias{RootedSPRSwap}
\title{Subtree pruning and rearrangement (SPR)}
\usage{
SPR(tree, edgeToBreak = NULL, mergeEdge = NULL)

SPRMoves(tree, edgeToBreak = integer(0))

\method{SPRMoves}{phylo}(tree, edgeToBreak = integer(0))

\method{SPRMoves}{matrix}(tree, edgeToBreak = integer(0))

SPRSwap(
  parent,
  child,
  nEdge = length(parent),
  nNode = nEdge/2L,
  edgeToBreak = NULL,
  mergeEdge = NULL
)

RootedSPR(tree, edgeToBreak = NULL, mergeEdge = NULL)

RootedSPRSwap(
  parent,
  child,
  nEdge = length(parent),
  nNode = nEdge/2L,
  edgeToBreak = NULL,
  mergeEdge = NULL
)
}
\arguments{
\item{tree}{A bifurcating tree of class \code{\link[ape]{phylo}}, with all nodes resolved;}

\item{edgeToBreak}{the index of an edge to bisect, generated randomly if not specified.}

\item{mergeEdge}{the index of an edge on which to merge the broken edge.}

\item{parent}{Integer vector corresponding to the first column of the edge
matrix of a tree of class \code{\link[ape]{phylo}}, i.e.
\code{tree[["edge"]][, 1]}}

\item{child}{Integer vector corresponding to the second column of the edge
matrix of a tree of class \code{\link[ape]{phylo}}, i.e.
\code{tree[["edge"]][, 2]}.}

\item{nEdge}{(optional) integer specifying the number of edges of a tree of
class \code{\link[ape]{phylo}}, i.e. \code{dim(tree$edge)[1]}}

\item{nNode}{(optional) Number of nodes.}
}
\value{
This function returns a tree in \code{phyDat} format that has undergone one \acronym{SPR} iteration.

\code{TBRMoves()} returns a list of all trees one SPR move away from
\code{tree}, with edges and nodes in preorder, rooted on the first-labelled tip.

a list containing two elements, corresponding in turn to the
rearranged parent and child parameters

a list containing two elements, corresponding in turn to the rearranged parent and child parameters
}
\description{
Perform one \acronym{SPR} rearrangement on a tree
}
\details{
Equivalent to \code{kSPR()} in the \pkg{phangorn} package, but faster.
Note that rearrangements that only change the position of the root WILL be returned by
\code{SPR}.  If the position of the root is irrelevant (as in Fitch parsimony, for example)
then this function will occasionally return a functionally equivalent topology.
\code{RootIrrelevantSPR} will search tree space more efficiently in these cases.
Branch lengths are not (yet) supported.

All nodes in a tree must be bifurcating; \link[ape:collapse.singles]{ape::collapse.singles} and
\link[ape:multi2di]{ape::multi2di} may help.
}
\section{Functions}{
\itemize{
\item \code{SPRSwap()}: faster version that takes and returns parent and child parameters

\item \code{RootedSPR()}: Perform \acronym{SPR} rearrangement, retaining position of root

\item \code{RootedSPRSwap()}: faster version that takes and returns parent and child parameters

}}
\examples{
{
tree <- ape::rtree(20, br=FALSE)
SPR(tree)
}
}
\references{
The \acronym{SPR} algorithm is summarized in
\insertRef{Felsenstein2004}{TreeSearch}
}
\seealso{
\itemize{
\item \code{\link[=RootedSPR]{RootedSPR()}}: useful when the position of the root node should be retained.
}

Other tree rearrangement functions: 
\code{\link{NNI}()},
\code{\link{TBR}()}
}
\author{
Martin R. Smith
}
\concept{tree rearrangement functions}
