% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPP.R
\name{PPP}
\alias{PPP}
\title{Compute Posterior Predictive P-Values}
\usage{
PPP(fittedModel, M = 1000, nCPU = 4, T2 = TRUE, type = "X2")
}
\arguments{
\item{fittedModel}{fitted latent-trait or beta MPT model (\code{\link{traitMPT}}, \code{\link{betaMPT}})}

\item{M}{number of posterior predictive samples. As a maximum, the number of posterior samples in \code{fittedModel} is used.}

\item{nCPU}{number of CPUs used for parallel sampling. For large models and many participants, this requires considerable computer-memory resources (as a remedy, use \code{nCPU=1}).}

\item{T2}{whether to compute T2 statistic to check coveriance structure (can
take a lot of time). If some participants do not have responses for some
trees, (co)variances are computed by pairwise deletion of the corresponding
persons.}

\item{type}{whether the T1 statistic of expected means is computed using
Person's \code{"X2"} or the likelihood-ratio statistic \code{"G2"}}
}
\description{
Computes posterior predictive p-values to test model fit.
}
\references{
Klauer, K. C. (2010). Hierarchical multinomial processing tree
models: A latent-trait approach. Psychometrika, 75, 70-98.
}
\author{
Daniel Heck
}
