% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CombatTumor.R
\name{combat_tumor}
\alias{combat_tumor}
\title{Process and Correct Batch Effects in Tumor Data}
\usage{
combat_tumor(
  tumor_data_path,
  CombatTumor_output_path,
  auto_mode = FALSE,
  default_input = "01,06"
)
}
\arguments{
\item{tumor_data_path}{The path to the tumor data stored in an RDS file.}

\item{CombatTumor_output_path}{A character string specifying the path where the output RDS file will be saved.}

\item{auto_mode}{Logical. If set to TRUE, the function will not prompt the user for input and
will instead use the values provided in default_input. Default is FALSE.}

\item{default_input}{Character string. When auto_mode is TRUE, this parameter specifies the default
tumor types to be retained. It should be provided as a comma-separated string (e.g., "01,06").}
}
\value{
A data.frame with corrected values after the ComBat_seq adjustment. Note that this function also saves the
        combat_count_df data as an RDS file at the specified output path.
}
\description{
The function first extracts histological types from the provided tumor data set.
After displaying these types, the user is prompted to input specific types to retain.
The data is then filtered based on this input.

Note: This example assumes that different tumor types represent different batches in a general sense.
Users need to adjust the batch and group vectors based on real-life scenarios.
}
\details{
This function takes a tumor data set, asks the user for specific tumor types to retain,
and then corrects for batch effects using the ComBat_seq function from the 'sva' package.


The ComBat_seq function from the sva package is used to correct batch effects.
The function requires the 'sva' package to be installed and loaded externally.
}
\examples{
tumor_file <- system.file("extdata",
                          "SKCM_Skin_TCGA_exp_tumor_test.rds",
                          package = "TransProR")
output_file <- file.path(tempdir(), "SKCM_combat_count.rds")

  SKCM_combat_count <- combat_tumor(
  tumor_data_path = tumor_file,
  CombatTumor_output_path = output_file,
  auto_mode = TRUE,
  default_input = "01,06"
)

head(SKCM_combat_count)[1:5, 1:5]

}
\seealso{
\code{\link[sva]{ComBat_seq}}
}
