% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07-visualization.R
\name{plot_juvenile_analysis}
\alias{plot_juvenile_analysis}
\title{Plot juvenile analysis}
\usage{
plot_juvenile_analysis(
  data,
  x_var,
  fill_var = NULL,
  length_cols = NULL,
  a = 0.0012,
  b = 3.1242,
  x_date_breaks = NULL,
  plot_type = "bars",
  title = NULL,
  subtitle = NULL,
  sort_by = "x",
  color_palette = NULL,
  facet_var = NULL,
  facet_cols = 2,
  bar_position = "dodge",
  y_limits = c(0, 100),
  use_facet_wrap = TRUE,
  group_by_type = TRUE,
  reference_line = NULL,
  theme_style = "light",
  legend_position = "bottom",
  rotate_x_labels = TRUE,
  na_to_zero = FALSE
)
}
\arguments{
\item{data}{Data frame with juvenile analysis data.}

\item{x_var}{Column name for x-axis variable.}

\item{fill_var}{Column name for fill/color variable.}

\item{length_cols}{Vector of length frequency column names.}

\item{a}{Length-weight relationship coefficient.}

\item{b}{Length-weight relationship exponent.}

\item{x_date_breaks}{Date breaks for x-axis (e.g., "1 day", "1 month").}

\item{plot_type}{Plot type: "bars", "lines", "points", "mixed".}

\item{title}{Plot title.}

\item{subtitle}{Plot subtitle.}

\item{sort_by}{Sorting method: "x", "number", "weight".}

\item{color_palette}{Custom color palette.}

\item{facet_var}{Variable for faceting.}

\item{facet_cols}{Number of facet columns.}

\item{bar_position}{Bar position: "dodge", "stack", "fill".}

\item{y_limits}{Y-axis limits.}

\item{use_facet_wrap}{Use facet wrap for juvenile type.}

\item{group_by_type}{Group by juvenile type when not faceting.}

\item{reference_line}{Reference line value (e.g., legal limit).}

\item{theme_style}{Theme style: "classic", "minimal", "light", "dark".}

\item{legend_position}{Legend position.}

\item{rotate_x_labels}{Rotate x-axis labels.}

\item{na_to_zero}{Convert NA values to zeros.}
}
\value{
ggplot object.
}
\description{
Creates comprehensive visualizations for juvenile fish analysis including
bar charts, line plots, and comparative analyses. This function consolidates
all juvenile plotting functionality.
}
\examples{
\dontrun{
plot_juvenile_analysis(
  data = fishery_data,
  x_var = "date",
  length_cols = paste0("length_", seq(8, 15, 0.5))
)

plot_juvenile_analysis(
  data = fishery_data,
  x_var = "date",
  fill_var = "vessel",
  length_cols = length_columns,
  plot_type = "mixed",
  reference_line = 10,
  title = "Juvenile Analysis by Vessel and Date"
)
}

}
