% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-fishery-statistics.R
\name{calculate_juvenile_statistics}
\alias{calculate_juvenile_statistics}
\title{Calculate juvenile statistics for a group}
\usage{
calculate_juvenile_statistics(
  frequencies,
  length_values,
  juvenile_limit = 12,
  a = 0.0012,
  b = 3.1242
)
}
\arguments{
\item{frequencies}{Numeric vector of frequencies by length.}

\item{length_values}{Numeric vector of corresponding lengths.}

\item{juvenile_limit}{Length threshold for juveniles.}

\item{a}{Coefficient of length-weight relationship.}

\item{b}{Exponent of length-weight relationship.}
}
\value{
Data frame with juvenile statistics.
}
\description{
Helper function that calculates juvenile percentages in number and weight.
Used internally by summarize_juveniles_by_group.
}
\examples{
frequencies <- c(10, 15, 25, 30, 20, 10)
lengths <- c(8, 9, 10, 11, 12, 13)
stats <- calculate_juvenile_statistics(frequencies, lengths)

}
