% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine-multi-single-dist-tbl.R
\name{tidy_multi_single_dist}
\alias{tidy_multi_single_dist}
\title{Generate Multiple Tidy Distributions of a single type}
\usage{
tidy_multi_single_dist(.tidy_dist = NULL, .param_list = list())
}
\arguments{
\item{.tidy_dist}{The type of \code{tidy_} distribution that you want to run. You
can only choose one.}

\item{.param_list}{This must be a \code{list()} object of the parameters that you
want to pass through to the TidyDensity \code{tidy_} distribution function.}
}
\value{
A tibble
}
\description{
Generate multiple distributions of data from the same \code{tidy_}
distribution function.
}
\details{
Generate multiple distributions of data from the same \code{tidy_}
distribution function. This allows you to simulate multiple distributions of
the same family in order to view how shapes change with parameter changes. You
can then visualize the differences however you choose.
}
\examples{

tidy_multi_single_dist(
  .tidy_dist = "tidy_normal",
  .param_list = list(
    .n = 50,
    .mean = c(-1, 0, 1),
    .sd = 1,
    .num_sims = 3,
    .return_tibble = TRUE
  )
)

tidy_multi_single_dist(
  .tidy_dist = "tidy_normal",
  .param_list = list(
    .n = 50,
    .mean = c(-1, 0, 1),
    .sd = 1,
    .num_sims = 3,
    .return_tibble = FALSE
  )
)

}
\seealso{
Other Multiple Distribution: 
\code{\link{tidy_combine_distributions}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Multiple Distribution}
