% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tprHeight.r
\name{tprHeight}
\alias{tprHeight}
\alias{tprHeight,tprTrees-method}
\title{Estimate height for given diameter w/ or w/o bark}
\usage{
tprHeight(obj, Dx, bark = TRUE, cp = TRUE, mono = TRUE, Rfn = NULL)

\S4method{tprHeight}{tprTrees}(obj, Dx, bark = TRUE, cp = TRUE, mono = TRUE, Rfn = NULL)
}
\arguments{
\item{obj}{object of class 'tprTrees'}

\item{Dx}{diameter for which height is required}

\item{bark}{should given diameter be considered over or under bark?}

\item{cp}{cartesian product, i.e. apply all \code{Hx} to all trees, defaults
to TRUE}

\item{mono}{logical, defaults to true. If calibrated taper curve is
non-monotonic at stem base, a support diameter is added.}

\item{Rfn}{Rfn setting for residuals error matrix, defaults to
\code{list(fn="sig2")}, see \code{\link[TapeR]{resVar}}.}
}
\value{
estimated height of given diameter
}
\description{
Function to extract the height of given diameter w/ or w/o bark
from taper curve
}
\section{Methods (by class)}{
\itemize{
\item \code{tprHeight(tprTrees)}: method for class 'tprTrees'

}}
\examples{
obj <- tprTrees(spp=c(1, 3, 8, 15),
                Dm=list(c(30, 28), c(30, 28), c(30, 28), c(30, 28)),
                Hm=list(c(1.3, 5), c(1.3, 5), c(1.3, 5), c(1.3, 5)),
                Ht = rep(30, 4))
tprHeight(obj, Dx = c(30, 7), bark=TRUE)
tprHeight(obj, Dx = c(30, 7), bark=FALSE)

## no cartesion product between obj and Dx, i.e. cp=FALSE
## Dx is recycled if necessary
tprHeight(obj, Dx = c(30, 7), bark=FALSE, cp=FALSE)
}
\seealso{
\code{\link{tprDiameter}}, \code{\link{tprDiameterCpp}}
}
