% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estHeight.r
\name{estHeight}
\alias{estHeight}
\title{Estimate tree height by DBH according to BWI3}
\usage{
estHeight(d13, sp, qtl = NULL)
}
\arguments{
\item{d13}{numeric vector of diameter in breast height [cm]}

\item{sp}{TapeS species code, see also \code{\link{tprSpeciesCode}}}

\item{qtl}{desired quantile of height, either NULL (LS-regression) or one of
17, 50, 83 (quantile regression)}
}
\value{
a vector of same length as \code{d13} or \code{sp}, with tree
height in [m].
}
\description{
Function calculates expected tree height given diameter in
breast height and species code
}
\details{
Function evaluates the expected value of a Pettersen-Height Function
based on diameter in breast height and tree species code.
The Pettersen-Function (\eqn{h = 1.3 + (a + \frac{b}{dbh})^{-3}}) was fitted
on NFI 3 (BWI 3) data, using the main stand only.

\code{d13} and \code{sp} should be of equal length or one of it can
be > 1 if the other is of length 1. Then, the shorter object will be extended
to match the length of the longer object. See examples.

The quantile option return tree height at quantiles 17, 50 or 83. If
\code{qtl} is NULL, the result of a nonlinear least-squares regression is
provided.
}
\examples{
sp <- 1
d13 <- 30
estHeight(d13, sp)

sp <- 1
d13 <- seq(15, 50, 5)
estHeight(d13, sp)

sp <- 1:36
d13 <- 30
estHeight(d13, sp)
}
