% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/astprtrees.r
\name{data_coercion}
\alias{data_coercion}
\alias{nfi_as_tprtrees}
\alias{seg_as_tprtrees}
\alias{bdat_as_tprtrees}
\title{coerce different data sources into class 'tprTrees'}
\usage{
nfi_as_tprtrees(nfi, mapping = NULL)

seg_as_tprtrees(seg, mapping = NULL)

bdat_as_tprtrees(bdat)
}
\arguments{
\item{nfi}{data.frame with tree measurements as provided by german NFI}

\item{mapping}{mapping of column names}

\item{seg}{data.frame with measured tree segments, see details.}

\item{bdat}{data.frame holding data to process with rBDAT}
}
\value{
an object of class 'tprTrees', see \code{\link{tprTrees-class}}
}
\description{
coercion functions to make NFI, segment and 'BDAT' data
available as 'tprTrees' objects
}
\details{
The coerced data is automatically checked for validity by the class
constructor. For available species codes see \code{\link{tprSpeciesCode}}.

When coercing NFI (National forest inventory, BWI) data, one need
to provide the columns \code{BaTpr} (species code), \code{Bhd} (Dbh, [mm]),
\code{D03, [mm]} (diameter in 30\% of tree height) and \code{Hoehe} (tree
height, [dm]). Optionally, one can provide \code{H1} (measurement height of
\code{Bhd}, [dm]), \code{H2} (measurement height of \code{D03}, [dm]) as well
as \code{sHt} (measurement error of tree height, i.e. standard deviation [dm]);
otherwise these are assumed to be 1.3m, 30\% of tree height and 0 (zero),
respectively.

Additionally, the NFI database stores diameter as [mm] and height as [dm]; it
is *not* necessary to transform to [cm] and [m], as the function does this.
Equally, \code{sHt} [dm] is transformed to \code{sHt} [m].

Keep in mind that species codes of NFI are different from the taper models
for historical reasons (c.f. BDAT). Use the NFI table  ('x_Ba') to map
species codes beforehand (see examples).

Sectional measurements provide more information about the trunk of
a tree and are usually stored in a different way. They exhibit an arbitrary
amount of diameter measurements which also might vary from tree to tree.
Hence, \code{seg_as_tprtrees} expects a data.frame with columns
\code{Id}, \code{BaTpr} (species code), \code{Dm} (diameter measured, [cm]),
\code{Hm} (height of \code{Dm}, [m]) and optionally \code{Ht} (height of
tree, [m]). Tree height \code{Ht} can be included to
\code{Dm}-\code{Hm}-pairs with \code{Dm} being zero
(e.g. \code{Dm}=0, \code{Hm}=25). If \code{Ht} is given, it gains priority.

coercing object of class 'datBDAT' from R-Package "rBDAT" into
class 'tprTrees'
}
\section{Functions}{
\itemize{
\item \code{nfi_as_tprtrees()}: coercion of German NFI data

\item \code{seg_as_tprtrees()}: coercion of segmented data to class 'tprTrees'

\item \code{bdat_as_tprtrees()}: coercion of bdat data

}}
\examples{
# NFI data usually stored as integer and units: diameter=[mm] and height=[dm]
nfi <- data.frame(BaTpr=1L, Bhd=300L, D03=270L, Hoehe=250L)
tpr <- nfi_as_tprtrees(nfi)
tpr
tpr@sHt # defaults to 0

# one can provide measurement heights explicitly
nfi <- data.frame(spp=1, Bhd=300, H1=12, D03=270, H=250)
nfi_as_tprtrees(nfi, mapping=c(spp="BaTpr", H="Hoehe"))

# measurement error in height
nfi <- data.frame(BaTpr=1L, Bhd=300L, D03=270L, Hoehe=250L, sHt=15)
tpr <- nfi_as_tprtrees(nfi)
tpr@sHt
## coercing sectional measurements
data(DxHx.df, package = "TapeR")
DxHx.df$BaTpr <- 1 # Norway spruce
segtprtrees <- seg_as_tprtrees(DxHx.df, mapping=c(Dx="Dm", Hx="Hm"))

## extract tree height from Dm-Hm measurements if not given explicitly
DxHx.df$Ht <- NULL # remove height, as already included with Dm=0
segtprtrees <- seg_as_tprtrees(DxHx.df, mapping=c(Dx="Dm", Hx="Hm"))
segtprtrees
if(require(rBDAT)){
  bdt <- buildTree(list(spp=1, D1=30, D2=28, H2=7, H=25))
  bdat_as_tprtrees(bdt)
}


}
\seealso{
\code{\link{tprTrees-class}}, \code{\link{tprTrees}},
\code{\link{tprSpeciesCode}}
}
