% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkComp.r
\name{check_Comp}
\alias{check_Comp}
\title{generate and/or check validity of biomass function component names}
\usage{
check_Comp(component = NULL)
}
\arguments{
\item{component}{vector of biomass component names, see details}
}
\value{
a vector of component names
}
\description{
generate and/or check validity of biomass function component names
}
\details{
If \code{component} is NULL, by default, component name
for total aboveground biomass is returned. If is \code{all},
then all available component names are returned.
\itemize{
 \item{stw: stump wood}
 \item{stb: stump bark}
 \item{sw: solid wood with diameter above 7cm over bark}
 \item{sb: bark of component sw}
 \item{fwb: fine wood incl. bark}
 \item{ndl: needles}
 \item{agb: total aboveground biomass}
}
}
\examples{
\dontrun{
TapeS:::checkComp()
TapeS:::checkComp("AGB")
TapeS:::checkComp("biomass")
}

}
