% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/team_season_info.R
\name{team_season_info}
\alias{team_season_info}
\title{Extract arena, coach, record, and schedule information for a particular team
and season}
\usage{
team_season_info(team_id = NULL)
}
\arguments{
\item{team_id}{Team ID determined by NCAA for season. To find ID, use
\code{\link[=find_team_id]{find_team_id()}}.}
}
\value{
Returns a list that includes arena, coach, schedule, and record information.
}
\description{
The NCAA's main page for a team includes a tab called "Schedule/Results".
This function extracts information about the team's venue, coach, and
records, as well as the table of the schedule and results. This returns a
list, so you can subset specific components with \code{$} (e.g., for coach
information from an object called \code{output}, use \code{output$coach}).
}
\note{
This function \strong{requires internet connectivity} as it checks the
\href{https://stats.ncaa.org}{NCAA website} for information.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
team_season_info(team_id = "585290")
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions that extract team statistics: 
\code{\link{team_match_stats}()},
\code{\link{team_season_stats}()}
}
\concept{functions that extract team statistics}
