\name{bootstrap}
\alias{bootstrap}
\title{
The bootstrapp method for computing the variances of the estimators
}
\description{
This function uses the bootstrap method to compute the variances of the estimators and the associated p-values.
}
\usage{
bootstrap(surv, status, X, Sigma_e, Psi, K, r, dist, shape, scale, order, B, model)
}
\arguments{
  \item{surv}{An \eqn{n}-dimensional vector of observed times}
  \item{status}{An \eqn{n}-dimensional vector of censoring indicators}
  \item{X}{An \eqn{n \times p} matrix of the covariates, where \eqn{p} is greater than or equal to 2}
  \item{Sigma_e}{A \eqn{p \times p} positive definite covariance matrix}
  \item{Psi}{A user-specified sequence for generating synthetic data in the simulation step of the SIMEX method}
  \item{K}{A user-specified integer used for simulating data in the simulation step of the SIMEX method}
  \item{r}{A user-specified constant greater than 0 and smaller than or equal to 1. When \code{r=1}, the transformation model reduces to the proportional odds model.}
  \item{dist}{A user-specified distribution for the noise term in the AFT model. Options include Weibull distributions (\code{weibull}), exponential distributions (\code{exponential}), logistic distributions (\code{logistic}), and normal distributions (\code{normal}).}
  \item{shape}{A user-specified value for the shape parameter in the distribution (\code{dist}) }
  \item{scale}{A user-specified value for the scale parameter in the distribution (\code{dist}) }
  \item{order}{A positive integer (no smaller than 1) specifying the order of the polynomial functions used in the extrapolation step of the SIMEX method}
  \item{B}{A user-specified positive integer specifying the number of bootstrap replications }
  \item{model}{The specification of the survival model. Options include the Cox proportional hazards model (\code{model =="PH"}), the additive hazards model (\code{model =="AH"}), the accelerated failure time model (\code{model =="AFT"}), and the transformation model (\code{model =="TM"}). }

}


\details{
This function integrates four sub-functions (\code{SIMEX_PH}, \code{SIMEX_AH}, \code{SIMEX_AFT}, and \code{SIMEX_TM}) to compute the variances and p-values of the estimators using the bootstrap method, under the the Cox proportional hazards model, the additive hazards model, the accelerated failure time model, and the transformation model.
}


\value{
\item{est_beta}{A \eqn{p}-dimensional vector of the estimators associated with the covariates}
\item{est_theta}{A \eqn{p \times p} matrix of the estimators associated with the pairwise interaction of covariates}

\item{var(beta)}{A \eqn{p}-dimensional vector containing estimated variances for each estimator \eqn{\widehat{\beta}_j}}

\item{var(theta)}{A \eqn{p \times p} matrix containing estimated variances for each estimator \eqn{\widehat{\theta}_{s\nu}}}

\item{p-value_beta}{A \eqn{p}-dimensional vector containing the p-value for each estimator \eqn{\widehat{\beta}_j}}

\item{p-value_theta}{A \eqn{p \times p} matrix containing the p-value for each estimator \eqn{\widehat{\theta}_{s\nu}}}

}





\references{
Chen, L.-P. and Yi, G. Y. (2021). Analysis of noisy survival data with graphical proportional hazards measurement error models. \emph{Biometrics}, 77, 956–969.
}

\author{
Chen, L.-P. and Yi, G. Y.
}



\examples{
library(MASS)
library(glmnet)
library(survival)
library(ahaz)
n = 200
p = 4
Z = mvrnorm(n,rep(0,p), diag(1,p))
T = exp(Z[,1]+Z[,2]+Z[,3]*Z[,4] + runif(n,0,1))
C = rexp(n,1)
Y = pmin(T,C)
delta = (T<C)*1
SA = diag(c(0,0.6,0,0.6),dim(Z)[2])
X = Z + mvrnorm(n,rep(0,p), SA)

bootstrap(Y, delta, X, Sigma_e = SA, Psi = seq(0,1,length=5), K=10, order=2,B=5, model="PH")
}

\keyword{funtion}
\keyword{core}
