SIMEX_S1_AH = function(surv, status, X, Sigma_e, psi, k ) {

### Setup
t = NULL
n = dim(X)[1]
p = dim(X)[2]
mu_e = rep(0,p)
Sigma_e = Sigma_e

y = surv; delta = status
W = X
e = mvrnorm(n, mu_e, Sigma_e, tol = 1e-6, empirical = FALSE, EISPACK = FALSE)
W_S = W + sqrt(psi) * e
W_S = scale(W_S)

for(k in 1:n) {
graph =  as.numeric(W_S[k,]) %*% t(as.numeric(W_S[k,]))
graph = graph - diag(diag(graph))
t = rbind(t, c(W_S[k,], c(graph)))
}
#######

t = data.frame(t)
survAH = Surv(y,delta)
opt.tune = tune.ahazpen(survAH,t,penalty="lasso",tune="bic")
opt.tuning = median(opt.tune$lambda)
AH = ahazpen(survAH,t,penalty="lasso",lambda = opt.tuning)
beta = AH$beta[1:p]
theta = AH$beta[-c(1:p)]
return(c(beta,theta))

}
