% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cholesky.R
\name{Cholesky}
\alias{Cholesky}
\alias{cholXZ}
\alias{cholZX}
\title{Cholesky multiplication with Toeplitz variance matrices.}
\usage{
cholZX(Z, acf)

cholXZ(X, acf)
}
\arguments{
\item{Z}{Length-\code{N} or \verb{N x p} matrix of residuals.}

\item{acf}{Length-\code{N} autocorrelation vector of the Toeplitz variance matrix.}

\item{X}{Length-\code{N} or \verb{N x p} matrix of observations.}
}
\value{
Size \verb{N x p} residual or observation matrix.
}
\description{
Multiplies the Cholesky decomposition of the Toeplitz matrix with another matrix, or solves a system of equations with the Cholesky factor.
}
\details{
If \code{C == t(chol(toeplitz(acf)))}, then \code{cholZX()} computes \code{C \%*\% Z} and \code{cholZX()} computes \code{solve(C, X)}.  Both functions use the Durbin-Levinson algorithm.
}
\examples{
N <- 10
p <- 2
acf <- exp(-(1:N - 1))

Z <- matrix(rnorm(N * p), N, p)
cholZX(Z = Z, acf = acf) - (t(chol(toeplitz(acf))) \%*\%  Z)

X <- matrix(rnorm(N * p), N, p)
cholXZ(X = X, acf = acf) - solve(t(chol(toeplitz(acf))), X)
}
