% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thin.R
\name{thin}
\alias{thin}
\title{thin a series of events (e.g. fossil occurrences)}
\usage{
thin(x, thin)
}
\arguments{
\item{x}{numeric vectors with events (e.g. locations, height, times)}

\item{thin}{a function used for thinning}
}
\value{
numeric vector, events after thinning. Depending on the modeling framework, these events can represent fossil ages/locations or first/last occurrences, and the thinning taphonomic or ecological effects.
}
\description{
Thins a vector of events using the function thin, meaning the probability that the ith event in x is preserved is given by \emph{thin(x(i))}. Values of
\code{thin} below 0 and above 1 are ignored.
Is used to model niche preferences in \code{apply_niche} and taphonomic effects in \code{apply_taphonomy}.
}
\examples{

x = p3(rate = 100, from = 0, to = 3 * pi) # simulate Poisson point process
y = thin(x, sin)
hist(y) # not how negative values of sin are treated as 0
yy = thin(x, function(x) 5 * sin(x))
hist(yy) # note how values of 5 * sin above 1 are not affecting the thinning


}
\seealso{
\itemize{
\item \code{\link[=apply_niche]{apply_niche()}} and \code{\link[=apply_taphonomy]{apply_taphonomy()}} for use cases with biological meaning. Use \code{thin} to model effects of taphonomy and ecology for event data.
}
}
