% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_alpha.R
\name{find_alphas}
\alias{find_alphas}
\title{Function to find the value of alpha}
\usage{
find_alphas(beta, fertility_rates, tol = 1e-22)
}
\arguments{
\item{beta}{A numeric value representing the beta parameter of Weibull distribution.}

\item{fertility_rates}{A numeric vector containing the fertility rates.}

\item{tol}{A numeric value representing the tolerance for the \code{uniroot} method. Default is \code{1e-22}.}
}
\value{
A numeric value giving the estimated value of alpha, either found by \code{uniroot} or selected as the endpoint closest to zero if the root is not bracketed.
}
\description{
This function finds the value of alpha using the \code{uniroot} method for a given beta and a vector
of fertility rates. If the function values at the interval ends do not have opposite signs,
it returns the closest value to 0.
}
\examples{
find_alphas(1.2, c(0.2, 0.3, 0.5, 0.4))
}
