% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{createRWrapperForSql}
\alias{createRWrapperForSql}
\title{Create an R wrapper for SQL}
\usage{
createRWrapperForSql(
  sqlFilename,
  rFilename,
  packageName,
  createRoxygenTemplate = TRUE
)
}
\arguments{
\item{sqlFilename}{The SQL file.}

\item{rFilename}{The name of the R file to be generated. Defaults to the name of the
SQL file with the extension reset to R.}

\item{packageName}{The name of the package that will contains the SQL file.}

\item{createRoxygenTemplate}{If true, a template of Roxygen comments will be added.}
}
\description{
\code{createRWrapperForSql} creates an R wrapper for a parameterized SQL file. The created R script
file will contain a single function, that executes the SQL, and accepts the same parameters as
specified in the SQL.
}
\details{
This function reads the declarations of defaults in the parameterized SQL file, and creates an R
function that exposes the parameters. It uses the \code{loadRenderTranslateSql} function, and
assumes the SQL will be used inside a package. To use inside a package, the SQL file should be
placed in the inst/sql/sql_server folder of the package.
}
\examples{
\dontrun{
# This will create a file called CohortMethod.R:
createRWrapperForSql("CohortMethod.sql", packageName = "CohortMethod")
}
}
