% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{is.outside_CI}
\alias{is.outside_CI}
\title{Evaluate whether parameter is outside a given confidence interval}
\usage{
is.outside_CI(P0, CI)
}
\arguments{
\item{P0}{parameter to evaluate}

\item{CI}{confidence interval}
}
\value{
logical
}
\description{
Returns \code{TRUE} if parameter reflecting a null hypothesis
falls outside a given confidence interval. This is an alternative approach
to writing an experiment that returns a p-value.
}
\examples{

p0 <- .3
CI <- c(.2, .4)
is.outside_CI(p0, CI)

# complement indicates if p0 is within CI
!is.outside_CI(p0, CI)


}
\seealso{
\code{\link{is.CI_within}}, \code{\link{Spower}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
