% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\name{params}
\alias{params}
\alias{parameters}
\alias{simList-accessors-params}
\alias{params,simList-method}
\alias{params<-}
\alias{params<-,simList-method}
\alias{P}
\alias{P<-}
\alias{parameters,simList-method}
\title{Get and set simulation parameters}
\usage{
params(sim)

\S4method{params}{simList}(sim)

params(sim) <- value

\S4method{params}{simList}(sim) <- value

P(sim, param, module)

P(sim, param, module) <- value

parameters(sim, asDF = FALSE)

\S4method{parameters}{simList}(sim, asDF = FALSE)
}
\arguments{
\item{sim}{A \code{simList} object from which to extract element(s) or in which to replace element(s).}

\item{value}{The parameter value to be set (in the corresponding \code{module} and \code{param}).}

\item{param}{Optional character string indicating which parameter to choose.}

\item{module}{Optional character string indicating which module params should come from.}

\item{asDF}{Logical. For \code{parameters}, if TRUE, this will produce a single
data.frame of all model parameters. If FALSE, then it will return
a data.frame with 1 row for each parameter within nested lists,
with the same structure as \code{params}.}
}
\value{
Returns or sets the value of the slot from the \code{simList} object.
}
\description{
\code{params}, \code{P} and \code{Par} (an active binding, like "mod") access the parameter
slot in the \code{simList}.
\code{params} has a replace method, so can be used to update a parameter value.
}
\details{
\code{parameters} will extract only the metadata with the metadata defaults,
NOT the current values that may be overwritten by a user. See examples.
}
\note{
The differences between \code{P()}, \code{params()} and being explicit with passing arguments
are mostly a question of speed and code compactness.
The computationally fastest way to get a parameter is to specify \code{moduleName} and parameter name,
as in: \code{P(sim, "paramName", "moduleName")} (replacing \code{moduleName} and \code{paramName} with your
specific module and parameter names), but it is more verbose than \code{P(sim)$paramName}.
Note: the important part for speed (e.g., 2-4x faster) is specifying the \code{moduleName}.
Specifying the parameter name is <5\% faster.
}
\examples{
s <- simInit()
# add a parameter to tmp module
params(s)$tmp <- list(a = 1)

# Only work inside a module, inside a function with `sim` is an argument
# P(s, "a") # get "a" parameter inside the current module
# Par$a     # same. Get "a" parameter inside the current module

if (requireNamespace("NLMR", quietly = TRUE) &&
    requireNamespace("SpaDES.tools", quietly = TRUE)) {
  opts <- options("spades.moduleCodeChecks" = FALSE) # not necessary for example
  modules <- list("randomLandscapes")
  paths <- list(modulePath = getSampleModules(tempdir()))
  mySim <- simInit(modules = modules, paths = paths,
                   params = list(.globals = list(stackName = "landscape")))

  # update some parameters using assignment -- currently only params will work
  params(mySim)$randomLandscapes$nx <- 200
  params(mySim)$randomLandscapes$ny <- 200

  parameters(mySim) # Does not contain these user overridden values

  # These next 2 are same here because they are not within a module
  P(mySim)          # Does contain the user overridden values
  params(mySim)     # Does contain the user overridden values

  # NOTE -- deleting a parameter will affect params and P, not parameters
  params(mySim)$randomLandscapes$nx <- NULL
  params(mySim)$randomLandscapes$ny <- NULL

  parameters(mySim) # Shows nx and ny

  # These next 2 are same here because they are not within a module
  P(mySim)          # nx and ny are Gone
  params(mySim)     # nx and ny are Gone

  options(opts) # reset
}
}
\seealso{
\link{SpaDES.core-package}, specifically the section 1.2.1 on Simulation parameters.

Other functions to access elements of a 'simList' object: 
\code{\link{.addDepends}()},
\code{\link{checkpointFile}()},
\code{\link{envir}()},
\code{\link{events}()},
\code{\link{globals}()},
\code{\link{inputs}()},
\code{\link{modules}()},
\code{\link{objs}()},
\code{\link{packages}()},
\code{\link{paths}()},
\code{\link{progressInterval}()},
\code{\link{times}()}
}
\concept{functions to access elements of a 'simList' object}
