% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\docType{data}
\name{WRB_4th_2022}
\alias{WRB_4th_2022}
\title{World Reference Base for Soil Resources (4th Edition, 2022)}
\format{
An object of class \code{list} of length 3.
}
\usage{
data(WRB_4th_2022)
}
\description{
World Reference Base for Soil Resources (4th Edition, 2022)
}
\details{
A \emph{list} containing three \emph{data.frame} elements \code{"rsg"}, \code{"pq"}, and \code{"sq"}
providing information on the 'Representative Soil Groups', 'Principal
Qualifiers,' and 'Supplementary Qualifiers,' respectively.

Each element has the column \code{"code"} which is a number (1-32) referring to
the position in the Reference Soil Groups, and the column
\code{"reference_soil_group"} which is the corresponding group name. The \code{"pq"}
and \code{"sq"} qualifier name columns (\code{primary_qualifier} and
\code{supplementary_qualifier}) contain individual qualifier terms. Related
qualifiers are identified using \code{qualifier_group} column derived from
qualifier names separated with a forward slash \code{" / "}
\itemize{
\item The \emph{data.frame} \code{"rsg"} has column \code{"criteria"}, describing the logical criteria for each Reference Soil Group.
\item The \emph{data.frame} \code{"pq"} has qualifier names in column \code{"principal_qualifier"}
\item The \emph{data.frame} \code{"sq"} has column \code{"supplementary_qualifier"}.
}
}
\references{
IUSS Working Group WRB. 2022. World Reference Base for Soil Resources.
International soil classification system for naming soils and creating
legends for soil maps. 4th edition. International Union of Soil Sciences
(IUSS), Vienna, Austria.
}
\keyword{datasets}
