## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(SoilTaxonomy)

## -----------------------------------------------------------------------------
data(ST_features, package = "SoilTaxonomy")

## -----------------------------------------------------------------------------
str(get_ST_features(name = "mollic epipedon"))

## -----------------------------------------------------------------------------
epipedons <- get_ST_features(group = "surface")

## -----------------------------------------------------------------------------
str(epipedons)

## -----------------------------------------------------------------------------
subset(epipedons, name == "Anthropic Epipedon")$description

## -----------------------------------------------------------------------------
subset(epipedons, name == "Anthropic Epipedon")$criteria

## -----------------------------------------------------------------------------
get_ST_features(chapter = 2)$name

## -----------------------------------------------------------------------------
get_ST_features(chapter = 3)$name

## -----------------------------------------------------------------------------
get_ST_features(page = 18:20)$name

