% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Expression_calculate.R
\name{calculate_expression}
\alias{calculate_expression}
\title{Counts average expression of gene set (Use in package)}
\usage{
calculate_expression(
  object,
  features,
  assay = NULL,
  cluster_col = NULL,
  colour_low = "white",
  colour_high = "navy"
)
}
\arguments{
\item{object}{Enter a Seurat object.}

\item{features}{Enter one or a set of markers.}

\item{assay}{Enter the assay used by the Seurat object, such as "RNA". Default
parameters use "assay = NULL".}

\item{cluster_col}{Enter the meta.data column in the Seurat object to be
annotated, such as "seurat_cluster". Default parameters use "cluster_col = NULL".}

\item{colour_low}{Color for lowest expression level. (default = "white")}

\item{colour_high}{Color for highest expression level. (default = "black")}
}
\value{
Average expression genes and relatied informations in the input "Seurat" object
given "cluster_col" and given "features".
}
\description{
Counts average expression of gene set (Use in package)
}
\seealso{
Other Section_1_Functions_Use_in_Package: 
\code{\link{calculate_cluster_variability}()},
\code{\link{calculate_expression_skewness}()},
\code{\link{calculate_probability}()},
\code{\link{estimate_batch_effect}()},
\code{\link{extract_dataset_features}()},
\code{\link{generate_training_data}()},
\code{\link{postprocess_parameters}()},
\code{\link{predict_optimal_parameters}()},
\code{\link{train_parameter_model}()}
}
\concept{Section_1_Functions_Use_in_Package}
