% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_dist.R
\name{sim_nlf}
\alias{sim_nlf}
\title{Define a non-linear relationship}
\usage{
sim_nlf(
  formula = ~alpha - ((depth - mu)^2)/(2 * sigma^2),
  coeff = list(alpha = 0, mu = 200, sigma = 70)
)
}
\arguments{
\item{formula}{A formula describing parametric relationships between the data and coefficients.
The data used in \code{\link[=sim_distribution]{sim_distribution()}} consist of grid coordinates expanded across ages and years,
and include columns such as \code{"x"}, \code{"y"}, \code{"depth"}, \code{"cell"}, \code{"division"}, \code{"strat"}, \code{"age"}, and \code{"year"}.
Coefficient values referenced in the formula must be provided in the \code{coeff} argument as a named list.}

\item{coeff}{A named list of coefficient values used in \code{formula}.}
}
\value{
A function that can be passed to \code{\link[=sim_distribution]{sim_distribution()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
Closure to be used in \code{\link[=sim_distribution]{sim_distribution()}}.
}
\examples{
## Make a grid and replicate data for 5 ages and 5 years
## (This mimics what happens inside sim_distribution)
grid <- make_grid(shelf_width = 10)
grid_xy <- data.frame(grid)
i <- rep(seq(nrow(grid_xy)), times = 5)
a <- rep(1:5, each = nrow(grid_xy))
grid_xy <- grid_xy[i, ]
grid_xy$age <- a
i <- rep(seq(nrow(grid_xy)), times = 5)
y <- rep(1:5, each = nrow(grid_xy))
grid_xy <- grid_xy[i, ]
grid_xy$year <- y

## Define a non-linear function to apply to the expanded grid
## This example imposes ontogenetic deepening via a parabolic depth effect
nlf <- sim_nlf(
  formula = ~ alpha - ((depth - mu + beta * age)^2) / (2 * sigma^2),
  coeff = list(alpha = 0, mu = 200, sigma = 70, beta = -70)
)
grid_xy$depth_effect <- nlf(grid_xy)

library(plotly)
grid_xy |>
  filter(year == 1) |>
  plot_ly(x = ~depth, y = ~depth_effect, split = ~age) |>
  add_lines()

}
